package org.dronda.lib.jdbi

import org.jdbi.v3.core.Handle
import org.jdbi.v3.core.Jdbi
import org.jdbi.v3.core.config.Configurable
import org.jdbi.v3.core.kotlin.KotlinMapper
import org.jdbi.v3.core.result.RowView
import javax.sql.DataSource
import kotlin.reflect.KClass

public inline fun <R> Jdbi.transaction(crossinline body: Handle.() -> R): R {
    return inTransaction<R, RuntimeException> {
        body(it)
    }
}

public inline fun <R> Jdbi.transactionCatching(crossinline body: Handle.() -> R): Result<R> {
    return kotlin.runCatching {
        transaction(body)
    }
}

public fun buildJdbi(dataSource: DataSource, apply: Jdbi.() -> Unit): Jdbi {
    return Jdbi.create(dataSource)
        .apply(apply)
}

public inline fun <reified T> RowView.getRow(): T = getRow(T::class.java)

public inline fun <reified T> RowView.getColumn(column: String): T = getColumn(column, T::class.java)

public fun <T, C: Any> Configurable<T>.registerKotlinMapper(clazz: KClass<C>, prefix: String): T =
    registerRowMapper(KotlinMapper(clazz, prefix))

