package org.dronda.lib.jdbi

import java.net.URI

public interface DatabaseCredentialProvider {
    public val jdbcConnectionString: String
    public val username: String
    public val password: String
}

public class DatabaseCredentialProviderImpl(
    connectionString: URI,
    scheme: String = "postgresql"
) : DatabaseCredentialProvider {
    override val username: String
    override val password: String
    override val jdbcConnectionString: String

    init {
        val hostname: String = connectionString.host
        val port: Int = connectionString.port
        val databaseName: String = connectionString.path.substring(1)
        val query: String = connectionString.query ?: ""
        val userInfo: String = connectionString.userInfo
        username = userInfo.substringBefore(":")
        password = userInfo.substringAfter(":")
        jdbcConnectionString = "jdbc:$scheme://$hostname:$port/${databaseName}?$query"
    }
}

