/*
 * Decompiled with CFR 0.152.
 */
package org.dronda.lib.jdbi;

import java.net.URI;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.dronda.lib.jdbi.DatabaseCredentialProvider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0014\u0010\f\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\t\u00a8\u0006\u000e"}, d2={"Lorg/dronda/lib/jdbi/DatabaseCredentialProviderImpl;", "Lorg/dronda/lib/jdbi/DatabaseCredentialProvider;", "connectionString", "Ljava/net/URI;", "scheme", "", "(Ljava/net/URI;Ljava/lang/String;)V", "jdbcConnectionString", "getJdbcConnectionString", "()Ljava/lang/String;", "password", "getPassword", "username", "getUsername", "dronda-commons-jdbi"})
public final class DatabaseCredentialProviderImpl
implements DatabaseCredentialProvider {
    @NotNull
    private final String username;
    @NotNull
    private final String password;
    @NotNull
    private final String jdbcConnectionString;

    public DatabaseCredentialProviderImpl(@NotNull URI connectionString, @NotNull String scheme) {
        Intrinsics.checkNotNullParameter((Object)connectionString, (String)"connectionString");
        Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
        String string = connectionString.getHost();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"connectionString.host");
        String hostname = string;
        int port = connectionString.getPort();
        String string2 = connectionString.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"connectionString.path");
        String string3 = string2;
        int n = 1;
        String string4 = string3.substring(n);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).substring(startIndex)");
        String databaseName = string4;
        String string5 = connectionString.getQuery();
        if (string5 == null) {
            string5 = "";
        }
        String query = string5;
        String string6 = connectionString.getUserInfo();
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"connectionString.userInfo");
        String userInfo = string6;
        this.username = StringsKt.substringBefore$default((String)userInfo, (String)":", null, (int)2, null);
        this.password = StringsKt.substringAfter$default((String)userInfo, (String)":", null, (int)2, null);
        this.jdbcConnectionString = "jdbc:" + scheme + "://" + hostname + ":" + port + "/" + databaseName + "?" + query;
    }

    public /* synthetic */ DatabaseCredentialProviderImpl(URI uRI, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = "postgresql";
        }
        this(uRI, string);
    }

    @Override
    @NotNull
    public String getUsername() {
        return this.username;
    }

    @Override
    @NotNull
    public String getPassword() {
        return this.password;
    }

    @Override
    @NotNull
    public String getJdbcConnectionString() {
        return this.jdbcConnectionString;
    }
}

