/*
 * Decompiled with CFR 0.152.
 */
package org.dronda.lib.jvm.encryption;

import java.io.InputStream;
import java.security.Key;
import java.security.SecureRandom;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 \u00162\u00020\u0001:\u0003\u0014\u0015\u0016B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0002J\u000e\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\t\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\fJ\u000e\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\bJ \u0010\u0010\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\bH\u0002J \u0010\u0010\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\bH\u0002J \u0010\u0013\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\bH\u0002J \u0010\u0013\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\bH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/dronda/lib/jvm/encryption/AESManager;", "", "keyStr", "", "(Ljava/lang/String;)V", "secretKey", "Ljavax/crypto/SecretKey;", "createInitializationVector", "", "decryptPayload", "encryption", "Lorg/dronda/lib/jvm/encryption/AESManager$AESEncryption;", "Ljava/io/InputStream;", "Lorg/dronda/lib/jvm/encryption/AESManager$AESInputStream;", "encryptPayload", "payload", "performAESDecryption", "iv", "cipherText", "performAESEncryption", "AESEncryption", "AESInputStream", "Companion", "dronda-commons-jvm"})
public final class AESManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SecretKey secretKey;

    public AESManager(@NotNull String keyStr) {
        Intrinsics.checkNotNullParameter((Object)keyStr, (String)"keyStr");
        byte[] key = Base64.getDecoder().decode(keyStr);
        this.secretKey = new SecretKeySpec(key, "AES");
    }

    @NotNull
    public final AESEncryption encryptPayload(@NotNull byte[] payload) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        byte[] iv = this.createInitializationVector();
        byte[] encryptedValue = this.performAESEncryption(payload, this.secretKey, iv);
        return new AESEncryption(encryptedValue, iv);
    }

    @NotNull
    public final AESInputStream encryptPayload(@NotNull InputStream payload) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        byte[] iv = this.createInitializationVector();
        InputStream encryptionStream = this.performAESEncryption(payload, this.secretKey, iv);
        return new AESInputStream(encryptionStream, iv);
    }

    @NotNull
    public final byte[] decryptPayload(@NotNull AESEncryption encryption) {
        Intrinsics.checkNotNullParameter((Object)encryption, (String)"encryption");
        return this.performAESDecryption(encryption.getValue(), this.secretKey, encryption.getIv());
    }

    @NotNull
    public final InputStream decryptPayload(@NotNull AESInputStream encryption) {
        Intrinsics.checkNotNullParameter((Object)encryption, (String)"encryption");
        return this.performAESDecryption(encryption.getValue(), this.secretKey, encryption.getIv());
    }

    private final byte[] createInitializationVector() {
        SecureRandom secureRandom;
        byte[] iv = new byte[16];
        SecureRandom $this$createInitializationVector_u24lambda_u240 = secureRandom = new SecureRandom();
        boolean bl = false;
        $this$createInitializationVector_u24lambda_u240.nextBytes(iv);
        return iv;
    }

    private final byte[] performAESEncryption(byte[] payload, SecretKey secretKey, byte[] iv) {
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        IvParameterSpec ivParameterSpec = new IvParameterSpec(iv);
        cipher.init(1, (Key)secretKey, ivParameterSpec);
        byte[] byArray = cipher.doFinal(payload);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"cipher.doFinal(payload)");
        return byArray;
    }

    private final InputStream performAESEncryption(InputStream payload, SecretKey secretKey, byte[] iv) {
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        IvParameterSpec ivParameterSpec = new IvParameterSpec(iv);
        cipher.init(1, (Key)secretKey, ivParameterSpec);
        return new CipherInputStream(payload, cipher);
    }

    private final byte[] performAESDecryption(byte[] cipherText, SecretKey secretKey, byte[] iv) {
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        IvParameterSpec ivParameterSpec = new IvParameterSpec(iv);
        cipher.init(2, (Key)secretKey, ivParameterSpec);
        byte[] byArray = cipher.doFinal(cipherText);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"cipher.doFinal(cipherText)");
        return byArray;
    }

    private final InputStream performAESDecryption(InputStream payload, SecretKey secretKey, byte[] iv) {
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        IvParameterSpec ivParameterSpec = new IvParameterSpec(iv);
        cipher.init(2, (Key)secretKey, ivParameterSpec);
        return new CipherInputStream(payload, cipher);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\t"}, d2={"Lorg/dronda/lib/jvm/encryption/AESManager$AESEncryption;", "", "value", "", "iv", "([B[B)V", "getIv", "()[B", "getValue", "dronda-commons-jvm"})
    public static final class AESEncryption {
        @NotNull
        private final byte[] value;
        @NotNull
        private final byte[] iv;

        public AESEncryption(@NotNull byte[] value, @NotNull byte[] iv) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)iv, (String)"iv");
            this.value = value;
            this.iv = iv;
        }

        @NotNull
        public final byte[] getValue() {
            return this.value;
        }

        @NotNull
        public final byte[] getIv() {
            return this.iv;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/dronda/lib/jvm/encryption/AESManager$AESInputStream;", "", "value", "Ljava/io/InputStream;", "iv", "", "(Ljava/io/InputStream;[B)V", "getIv", "()[B", "getValue", "()Ljava/io/InputStream;", "dronda-commons-jvm"})
    public static final class AESInputStream {
        @NotNull
        private final InputStream value;
        @NotNull
        private final byte[] iv;

        public AESInputStream(@NotNull InputStream value, @NotNull byte[] iv) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)iv, (String)"iv");
            this.value = value;
            this.iv = iv;
        }

        @NotNull
        public final InputStream getValue() {
            return this.value;
        }

        @NotNull
        public final byte[] getIv() {
            return this.iv;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004\u00a8\u0006\u0006"}, d2={"Lorg/dronda/lib/jvm/encryption/AESManager$Companion;", "", "()V", "getExpectedPaddedSize", "", "size", "dronda-commons-jvm"})
    public static final class Companion {
        private Companion() {
        }

        public final long getExpectedPaddedSize(long size) {
            long modded = size % (long)16;
            return size + ((long)16 - modded);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

