package org.dronda.lib.jvm.encryption

import org.dronda.lib.jvm.encryption.AlgorithmUtil.AES
import org.dronda.lib.jvm.encryption.AlgorithmUtil.AES_CBC_PKCS5_ALGORITHM
import java.io.InputStream
import java.security.SecureRandom
import java.util.Base64
import javax.crypto.Cipher
import javax.crypto.CipherInputStream
import javax.crypto.SecretKey
import javax.crypto.spec.IvParameterSpec
import javax.crypto.spec.SecretKeySpec

@Deprecated(
    message = "Use AesCbcPkcs5Encryptor instead",
    replaceWith = ReplaceWith("AesCbcPkcs5Encryptor"),
    level = DeprecationLevel.ERROR
)
public class AESManager(keyStr: String) {
    private val secretKey: SecretKey

    init {
        val key = Base64.getDecoder().decode(keyStr)
        secretKey = SecretKeySpec(key, AES)
    }

    public class AESEncryption(public val value: ByteArray, public val iv: ByteArray)
    public class AESInputStream(public val value: InputStream, public val iv: ByteArray)

    public fun encryptPayload(payload: ByteArray): AESEncryption {
        val iv = createInitializationVector()
        val encryptedValue = performAESEncryption(payload, secretKey, iv)
        return AESEncryption(encryptedValue, iv)
    }

    public fun encryptPayload(payload: InputStream): AESInputStream {
        val iv = createInitializationVector()
        val encryptionStream = performAESEncryption(payload, secretKey, iv)
        return AESInputStream(encryptionStream, iv)
    }

    public fun decryptPayload(encryption: AESEncryption): ByteArray {
        return performAESDecryption(encryption.value, secretKey, encryption.iv)
    }

    public fun decryptPayload(encryption: AESInputStream): InputStream {
        return performAESDecryption(encryption.value, secretKey, encryption.iv)
    }

    private fun createInitializationVector(): ByteArray {
        val iv = ByteArray(16)
        SecureRandom().apply {
            nextBytes(iv)
        }
        return iv
    }

    private fun performAESEncryption(payload: ByteArray, secretKey: SecretKey, iv: ByteArray): ByteArray {
        val cipher = Cipher.getInstance(AES_CBC_PKCS5_ALGORITHM)
        val ivParameterSpec = IvParameterSpec(iv)
        cipher.init(Cipher.ENCRYPT_MODE, secretKey, ivParameterSpec)
        return cipher.doFinal(payload)
    }

    private fun performAESEncryption(payload: InputStream, secretKey: SecretKey, iv: ByteArray): InputStream {
        val cipher = Cipher.getInstance(AES_CBC_PKCS5_ALGORITHM)
        val ivParameterSpec = IvParameterSpec(iv)
        cipher.init(Cipher.ENCRYPT_MODE, secretKey, ivParameterSpec)
        return CipherInputStream(payload, cipher)
    }

    private fun performAESDecryption(cipherText: ByteArray, secretKey: SecretKey, iv: ByteArray) : ByteArray {
        val cipher = Cipher.getInstance(AES_CBC_PKCS5_ALGORITHM)
        val ivParameterSpec = IvParameterSpec(iv)
        cipher.init(Cipher.DECRYPT_MODE, secretKey, ivParameterSpec)
        return cipher.doFinal(cipherText)
    }

    private fun performAESDecryption(payload: InputStream, secretKey: SecretKey, iv: ByteArray): InputStream {
        val cipher = Cipher.getInstance(AES_CBC_PKCS5_ALGORITHM)
        val ivParameterSpec = IvParameterSpec(iv)
        cipher.init(Cipher.DECRYPT_MODE, secretKey, ivParameterSpec)
        return CipherInputStream(payload, cipher)
    }

    public companion object {
        public fun getExpectedPaddedSize(size: Long): Long {
            val modded = size % 16
            return size + (16 - modded)
        }
    }
}
