/*
 * Decompiled with CFR 0.152.
 */
package org.dronda.lib.jvm.encryption;

import java.io.InputStream;
import java.security.Key;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.dronda.lib.jvm.encryption.AESEncryptionData;
import org.dronda.lib.jvm.encryption.AESInputStreamData;
import org.dronda.lib.jvm.encryption.Encryptor;
import org.dronda.lib.jvm.encryption.EncryptorKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \r2\u00020\u0001:\u0001\rB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\u0005\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\tH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/dronda/lib/jvm/encryption/AesGcmEncryptor;", "Lorg/dronda/lib/jvm/encryption/Encryptor;", "secretKey", "Ljavax/crypto/SecretKey;", "(Ljavax/crypto/SecretKey;)V", "decryptPayload", "", "encryption", "Lorg/dronda/lib/jvm/encryption/AESEncryptionData;", "Ljava/io/InputStream;", "Lorg/dronda/lib/jvm/encryption/AESInputStreamData;", "encryptPayload", "payload", "Companion", "dronda-commons-jvm"})
public final class AesGcmEncryptor
implements Encryptor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SecretKey secretKey;
    private static final int GCM_TAG_LENGTH_BITS = 128;
    private static final int GCM_TAG_LENGTH_BYTES = 16;
    private static final int GCM_IV_SIZE = 12;

    public AesGcmEncryptor(@NotNull SecretKey secretKey) {
        Intrinsics.checkNotNullParameter((Object)secretKey, (String)"secretKey");
        this.secretKey = secretKey;
    }

    @Override
    @NotNull
    public AESEncryptionData encryptPayload(@NotNull byte[] payload) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
        byte[] iv = EncryptorKt.createInitializationVector(12);
        cipher.init(1, (Key)this.secretKey, new GCMParameterSpec(128, iv));
        byte[] byArray = cipher.doFinal(payload);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"cipher.doFinal(payload)");
        return new AESEncryptionData(byArray, iv);
    }

    @Override
    @NotNull
    public AESInputStreamData encryptPayload(@NotNull InputStream payload) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
        byte[] iv = EncryptorKt.createInitializationVector(12);
        cipher.init(1, (Key)this.secretKey, new GCMParameterSpec(128, iv));
        return new AESInputStreamData(new CipherInputStream(payload, cipher), iv);
    }

    @Override
    @NotNull
    public byte[] decryptPayload(@NotNull AESEncryptionData encryption) {
        Intrinsics.checkNotNullParameter((Object)encryption, (String)"encryption");
        Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
        cipher.init(2, (Key)this.secretKey, new GCMParameterSpec(128, encryption.getIv()));
        byte[] byArray = cipher.doFinal(encryption.getValue());
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"cipher.doFinal(encryption.value)");
        return byArray;
    }

    @Override
    @NotNull
    public InputStream decryptPayload(@NotNull AESInputStreamData encryption) {
        Intrinsics.checkNotNullParameter((Object)encryption, (String)"encryption");
        Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
        cipher.init(2, (Key)this.secretKey, new GCMParameterSpec(128, encryption.getIv()));
        return new CipherInputStream(encryption.getValue(), cipher);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bJ\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/dronda/lib/jvm/encryption/AesGcmEncryptor$Companion;", "", "()V", "GCM_IV_SIZE", "", "GCM_TAG_LENGTH_BITS", "GCM_TAG_LENGTH_BYTES", "expectedOutputSize", "", "plaintextLength", "from", "Lorg/dronda/lib/jvm/encryption/AesGcmEncryptor;", "secretKey", "", "fromBase64", "", "dronda-commons-jvm"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AesGcmEncryptor fromBase64(@NotNull String secretKey) {
            Intrinsics.checkNotNullParameter((Object)secretKey, (String)"secretKey");
            byte[] key = Base64.getDecoder().decode(secretKey);
            return new AesGcmEncryptor(new SecretKeySpec(key, "AES"));
        }

        @NotNull
        public final AesGcmEncryptor from(@NotNull byte[] secretKey) {
            Intrinsics.checkNotNullParameter((Object)secretKey, (String)"secretKey");
            return new AesGcmEncryptor(new SecretKeySpec(secretKey, "AES"));
        }

        public final long expectedOutputSize(int plaintextLength) {
            return this.expectedOutputSize((long)plaintextLength);
        }

        public final long expectedOutputSize(long plaintextLength) {
            return plaintextLength + (long)16;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

