/*
 * Decompiled with CFR 0.152.
 */
package org.dronda.lib.jvm.encryption;

import java.io.InputStream;
import java.security.Key;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.dronda.lib.jvm.encryption.AESEncryptionData;
import org.dronda.lib.jvm.encryption.AESInputStreamData;
import org.dronda.lib.jvm.encryption.Encryptor;
import org.dronda.lib.jvm.encryption.EncryptorKt;
import org.jetbrains.annotations.NotNull;

@Deprecated(message="use dronda-commons-crypto")
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0007\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\u0005\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\tH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u0006H\u0016J \u0010\r\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0006H\u0002J \u0010\r\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0006H\u0002J \u0010\u0010\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0006H\u0002J \u0010\u0010\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0006H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/dronda/lib/jvm/encryption/AesCbcPkcs5Encryptor;", "Lorg/dronda/lib/jvm/encryption/Encryptor;", "secretKey", "Ljavax/crypto/SecretKey;", "(Ljavax/crypto/SecretKey;)V", "decryptPayload", "", "encryption", "Lorg/dronda/lib/jvm/encryption/AESEncryptionData;", "Ljava/io/InputStream;", "Lorg/dronda/lib/jvm/encryption/AESInputStreamData;", "encryptPayload", "payload", "performAESDecryption", "iv", "cipherText", "performAESEncryption", "Companion", "dronda-commons-jvm"})
public final class AesCbcPkcs5Encryptor
implements Encryptor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SecretKey secretKey;

    public AesCbcPkcs5Encryptor(@NotNull SecretKey secretKey) {
        Intrinsics.checkNotNullParameter((Object)secretKey, (String)"secretKey");
        this.secretKey = secretKey;
    }

    @Override
    @NotNull
    public AESEncryptionData encryptPayload(@NotNull byte[] payload) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        byte[] iv = EncryptorKt.createInitializationVector(16);
        byte[] encryptedValue = this.performAESEncryption(payload, this.secretKey, iv);
        return new AESEncryptionData(encryptedValue, iv);
    }

    @Override
    @NotNull
    public AESInputStreamData encryptPayload(@NotNull InputStream payload) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        byte[] iv = EncryptorKt.createInitializationVector(16);
        InputStream encryptionStream = this.performAESEncryption(payload, this.secretKey, iv);
        return new AESInputStreamData(encryptionStream, iv);
    }

    @Override
    @NotNull
    public byte[] decryptPayload(@NotNull AESEncryptionData encryption) {
        Intrinsics.checkNotNullParameter((Object)encryption, (String)"encryption");
        return this.performAESDecryption(encryption.getValue(), this.secretKey, encryption.getIv());
    }

    @Override
    @NotNull
    public InputStream decryptPayload(@NotNull AESInputStreamData encryption) {
        Intrinsics.checkNotNullParameter((Object)encryption, (String)"encryption");
        return this.performAESDecryption(encryption.getValue(), this.secretKey, encryption.getIv());
    }

    private final byte[] performAESEncryption(byte[] payload, SecretKey secretKey, byte[] iv) {
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        IvParameterSpec ivParameterSpec = new IvParameterSpec(iv);
        cipher.init(1, (Key)secretKey, ivParameterSpec);
        byte[] byArray = cipher.doFinal(payload);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"cipher.doFinal(payload)");
        return byArray;
    }

    private final InputStream performAESEncryption(InputStream payload, SecretKey secretKey, byte[] iv) {
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        IvParameterSpec ivParameterSpec = new IvParameterSpec(iv);
        cipher.init(1, (Key)secretKey, ivParameterSpec);
        return new CipherInputStream(payload, cipher);
    }

    private final byte[] performAESDecryption(byte[] cipherText, SecretKey secretKey, byte[] iv) {
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        IvParameterSpec ivParameterSpec = new IvParameterSpec(iv);
        cipher.init(2, (Key)secretKey, ivParameterSpec);
        byte[] byArray = cipher.doFinal(cipherText);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"cipher.doFinal(cipherText)");
        return byArray;
    }

    private final InputStream performAESDecryption(InputStream payload, SecretKey secretKey, byte[] iv) {
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        IvParameterSpec ivParameterSpec = new IvParameterSpec(iv);
        cipher.init(2, (Key)secretKey, ivParameterSpec);
        return new CipherInputStream(payload, cipher);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n\u00a8\u0006\f"}, d2={"Lorg/dronda/lib/jvm/encryption/AesCbcPkcs5Encryptor$Companion;", "", "()V", "from", "Lorg/dronda/lib/jvm/encryption/AesCbcPkcs5Encryptor;", "secretKey", "", "fromBase64", "", "getExpectedPaddedSize", "", "size", "dronda-commons-jvm"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AesCbcPkcs5Encryptor fromBase64(@NotNull String secretKey) {
            Intrinsics.checkNotNullParameter((Object)secretKey, (String)"secretKey");
            byte[] key = Base64.getDecoder().decode(secretKey);
            return new AesCbcPkcs5Encryptor(new SecretKeySpec(key, "AES"));
        }

        @NotNull
        public final AesCbcPkcs5Encryptor from(@NotNull byte[] secretKey) {
            Intrinsics.checkNotNullParameter((Object)secretKey, (String)"secretKey");
            return new AesCbcPkcs5Encryptor(new SecretKeySpec(secretKey, "AES"));
        }

        public final long getExpectedPaddedSize(long size) {
            long modded = size % (long)16;
            return size + ((long)16 - modded);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

