/*
 * Decompiled with CFR 0.152.
 */
package org.dronda.lib.jvm.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010(\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0004B\u0013\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0006\u0010\u000f\u001a\u00020\u000eJ\b\u0010\u0010\u001a\u00020\u000eH\u0002J\b\u0010\u0011\u001a\u00020\fH\u0016J \u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\fH\u0016R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/dronda/lib/jvm/io/CollectionSequenceInputStream;", "Ljava/io/InputStream;", "s1", "s2", "(Ljava/io/InputStream;Ljava/io/InputStream;)V", "streams", "", "(Ljava/util/List;)V", "inputStream", "iterator", "", "available", "", "close", "", "nextStream", "peekNextStream", "read", "b", "", "off", "len", "dronda-commons-jvm"})
public final class CollectionSequenceInputStream
extends InputStream {
    @NotNull
    private final Iterator<InputStream> iterator;
    @Nullable
    private InputStream inputStream;

    public CollectionSequenceInputStream(@NotNull List<? extends InputStream> streams) {
        Intrinsics.checkNotNullParameter(streams, (String)"streams");
        this.iterator = streams.iterator();
        this.peekNextStream();
    }

    /*
     * WARNING - void declaration
     */
    public CollectionSequenceInputStream(@NotNull InputStream s1, @NotNull InputStream s2) {
        void $this$_init__u24lambda_u240;
        ArrayList arrayList;
        Intrinsics.checkNotNullParameter((Object)s1, (String)"s1");
        Intrinsics.checkNotNullParameter((Object)s2, (String)"s2");
        ArrayList arrayList2 = arrayList = new ArrayList(2);
        CollectionSequenceInputStream collectionSequenceInputStream = this;
        boolean bl = false;
        $this$_init__u24lambda_u240.add(s1);
        $this$_init__u24lambda_u240.add(s2);
        collectionSequenceInputStream(arrayList);
    }

    public final void nextStream() throws IOException {
        InputStream inputStream = this.inputStream;
        if (inputStream != null) {
            inputStream.close();
        }
        this.peekNextStream();
    }

    private final void peekNextStream() {
        this.inputStream = this.iterator.hasNext() ? this.iterator.next() : null;
    }

    @Override
    public int available() throws IOException {
        int n;
        if (this.inputStream == null) {
            n = 0;
        } else {
            InputStream inputStream = this.inputStream;
            Intrinsics.checkNotNull((Object)inputStream);
            n = inputStream.available();
        }
        return n;
    }

    @Override
    public int read() throws IOException {
        while (this.inputStream != null) {
            InputStream inputStream = this.inputStream;
            Intrinsics.checkNotNull((Object)inputStream);
            int c = inputStream.read();
            if (c != -1) {
                return c;
            }
            this.nextStream();
        }
        return -1;
    }

    @Override
    public int read(@NotNull byte[] b, int off, int len) throws IOException {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        if (this.inputStream == null) {
            return -1;
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        do {
            InputStream inputStream = this.inputStream;
            Intrinsics.checkNotNull((Object)inputStream);
            int n = inputStream.read(b, off, len);
            if (n > 0) {
                return n;
            }
            this.nextStream();
        } while (this.inputStream != null);
        return -1;
    }

    @Override
    public void close() throws IOException {
        do {
            this.nextStream();
        } while (this.inputStream != null);
    }
}

