package org.dronda.lib.ktor.client.plugins

import kotlinx.datetime.Clock
import kotlinx.datetime.Instant
import kotlinx.serialization.Serializable
import kotlinx.serialization.json.Json
import kotlin.io.encoding.Base64
import kotlin.io.encoding.ExperimentalEncodingApi

private val json = Json { ignoreUnknownKeys = true }
@OptIn(ExperimentalEncodingApi::class)
internal fun decodeClaims(token: String): JwtToken? {
    return runCatching {
        val encodedPayload = token.substringAfter(".").substringBefore(".")
        json.decodeFromString<JwtToken>(
            Base64.decode(encodedPayload).decodeToString()
        )
    }.getOrNull()
}


@Serializable
internal data class JwtToken(
    val exp: Long?,
)

internal val JwtToken.isExpired: Boolean
    get() = this.exp?.let { Instant.fromEpochSeconds(exp) <= Clock.System.now() } ?: false

