package org.dronda.lib.ktor

import io.ktor.server.application.Application


public abstract class ConfigProvider(private val application: Application) {
    protected fun getConfig(name: String): String {
        return application.environment.config.propertyOrNull(name)?.getString() ?: handleError(name)
    }

    protected fun getEnvVar(name: String): String {
        return System.getenv(name) ?: handleError(name)
    }

    private fun handleError(credName: String): Nothing {
        error("$errorMessage: $credName")
    }

    protected abstract val errorMessage: String
}
