/*
 * Decompiled with CFR 0.152.
 */
package org.dronda.lib.ktor.auth;

import com.auth0.jwk.JwkProvider;
import com.auth0.jwk.JwkProviderBuilder;
import com.auth0.jwt.algorithms.Algorithm;
import io.ktor.server.application.Application;
import io.ktor.server.application.ApplicationCall;
import io.ktor.server.application.ApplicationPluginKt;
import io.ktor.server.application.Plugin;
import io.ktor.server.auth.Authentication;
import io.ktor.server.auth.AuthenticationConfig;
import io.ktor.server.auth.AuthenticationInterceptorsKt;
import io.ktor.server.auth.Principal;
import io.ktor.server.auth.jwt.JWTAuthenticationProvider;
import io.ktor.server.auth.jwt.JWTCredential;
import io.ktor.server.auth.jwt.JWTPrincipal;
import io.ktor.server.routing.Routing;
import io.ktor.util.pipeline.Pipeline;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.dronda.lib.ktor.auth.JWTAuthKt;
import org.dronda.lib.ktor.auth.JWTCredentials;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a#\u0010\u0002\u001a\u00020\u0003*\u00020\u00042\u0017\u0010\u0005\u001a\u0013\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\u0002\b\u0007\u001a\u0012\u0010\b\u001a\u00020\u0003*\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u001a\"\u0010\f\u001a\u00020\u0003*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u0001\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"JWT_AUTH", "", "authenticateWithJwt", "", "Lio/ktor/server/routing/Routing;", "build", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "installAuth", "Lio/ktor/server/application/Application;", "jwtCredentialsProvider", "Lorg/dronda/lib/ktor/auth/JWTCredentials;", "installJwtAuth", "Lio/ktor/server/auth/AuthenticationConfig;", "issuer", "realm", "audience", "dronda-commons-ktor"})
public final class JWTAuthKt {
    @NotNull
    public static final String JWT_AUTH = "auth-jwt";

    public static final void authenticateWithJwt(@NotNull Routing $this$authenticateWithJwt, @NotNull Function1<? super Routing, Unit> build) {
        Intrinsics.checkNotNullParameter((Object)$this$authenticateWithJwt, (String)"<this>");
        Intrinsics.checkNotNullParameter(build, (String)"build");
        String[] stringArray = new String[]{JWT_AUTH};
        AuthenticationInterceptorsKt.authenticate$default((Routing)$this$authenticateWithJwt, (String[])stringArray, (boolean)false, build, (int)2, null);
    }

    public static final void installAuth(@NotNull Application $this$installAuth, @NotNull JWTCredentials jwtCredentialsProvider) {
        Intrinsics.checkNotNullParameter((Object)$this$installAuth, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)jwtCredentialsProvider, (String)"jwtCredentialsProvider");
        ApplicationPluginKt.install((Pipeline)((Pipeline)$this$installAuth), (Plugin)((Plugin)Authentication.Companion), (Function1)((Function1)new Function1<AuthenticationConfig, Unit>(jwtCredentialsProvider){
            final /* synthetic */ JWTCredentials $jwtCredentialsProvider;
            {
                this.$jwtCredentialsProvider = $jwtCredentialsProvider;
                super(1);
            }

            public final void invoke(@NotNull AuthenticationConfig $this$install) {
                Intrinsics.checkNotNullParameter((Object)$this$install, (String)"$this$install");
                io.ktor.server.auth.jwt.JWTAuthKt.jwt((AuthenticationConfig)$this$install, (String)"auth-jwt", (Function1)((Function1)new Function1<JWTAuthenticationProvider.Config, Unit>(this.$jwtCredentialsProvider){
                    final /* synthetic */ JWTCredentials $jwtCredentialsProvider;
                    {
                        this.$jwtCredentialsProvider = $jwtCredentialsProvider;
                        super(1);
                    }

                    public final void invoke(@NotNull JWTAuthenticationProvider.Config $this$jwt) {
                        Intrinsics.checkNotNullParameter((Object)$this$jwt, (String)"$this$jwt");
                        $this$jwt.setRealm(this.$jwtCredentialsProvider.getRealm());
                        String string = this.$jwtCredentialsProvider.getIssuer();
                        String string2 = this.$jwtCredentialsProvider.getAudience();
                        Algorithm algorithm = Algorithm.RSA256((RSAPublicKey)this.$jwtCredentialsProvider.getPublicKey(), (RSAPrivateKey)this.$jwtCredentialsProvider.getPrivateKey());
                        Intrinsics.checkNotNullExpressionValue((Object)algorithm, (String)"RSA256(\n                \u2026vateKey\n                )");
                        $this$jwt.verifier(string, string2, algorithm, (Function1)installAuth.1.INSTANCE);
                        $this$jwt.validate((Function3)new Function3<ApplicationCall, JWTCredential, Continuation<? super Principal>, Object>(this.$jwtCredentialsProvider, null){
                            int label;
                            /* synthetic */ Object L$0;
                            final /* synthetic */ JWTCredentials $jwtCredentialsProvider;
                            {
                                this.$jwtCredentialsProvider = $jwtCredentialsProvider;
                                super(3, $completion);
                            }

                            /*
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        boolean bl;
                                        ResultKt.throwOnFailure((Object)object);
                                        JWTCredential jwtCredential = (JWTCredential)this.L$0;
                                        Object[] objectArray = new Boolean[]{Boxing.boxBoolean((boolean)Intrinsics.areEqual((Object)jwtCredential.getIssuer(), (Object)this.$jwtCredentialsProvider.getIssuer())), Boxing.boxBoolean((boolean)jwtCredential.getAudience().contains(this.$jwtCredentialsProvider.getAudience()))};
                                        Iterable $this$all$iv = CollectionsKt.listOf((Object[])objectArray);
                                        boolean $i$f$all = false;
                                        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                                            bl = true;
                                        } else {
                                            for (T element$iv : $this$all$iv) {
                                                boolean it = (Boolean)element$iv;
                                                boolean bl2 = false;
                                                if (!it) return null;
                                                boolean bl3 = true;
                                                if (bl3) continue;
                                                return null;
                                            }
                                            bl = true;
                                        }
                                        boolean conditions = bl;
                                        if (!conditions) return null;
                                        Principal principal = (Principal)new JWTPrincipal(jwtCredential.getPayload());
                                        return principal;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @Nullable
                            public final Object invoke(@NotNull ApplicationCall p1, @NotNull JWTCredential p2, @Nullable Continuation<? super Principal> p3) {
                                var var4_4 = new /* invalid duplicate definition of identical inner class */;
                                var4_4.L$0 = p2;
                                return var4_4.invokeSuspend(Unit.INSTANCE);
                            }
                        });
                    }
                }));
            }
        }));
    }

    public static final void installJwtAuth(@NotNull AuthenticationConfig $this$installJwtAuth, @NotNull String issuer, @NotNull String realm, @NotNull String audience) {
        Intrinsics.checkNotNullParameter((Object)$this$installJwtAuth, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)issuer, (String)"issuer");
        Intrinsics.checkNotNullParameter((Object)realm, (String)"realm");
        Intrinsics.checkNotNullParameter((Object)audience, (String)"audience");
        JwkProviderBuilder jwkProviderBuilder = new JwkProviderBuilder(issuer);
        long l = DurationKt.toDuration((int)12, (DurationUnit)DurationUnit.HOURS);
        int n = Duration.getNanosecondsComponent-impl((long)l);
        long l2 = Duration.getInWholeSeconds-impl((long)l);
        java.time.Duration duration = java.time.Duration.ofSeconds(l2, n);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"toComponents-impl(...)");
        JwkProvider jwkProvider = jwkProviderBuilder.cached(10L, duration).rateLimited(10L, 1L, TimeUnit.MINUTES).build();
        io.ktor.server.auth.jwt.JWTAuthKt.jwt((AuthenticationConfig)$this$installJwtAuth, (String)JWT_AUTH, (Function1)((Function1)new Function1<JWTAuthenticationProvider.Config, Unit>(realm, jwkProvider, issuer, audience){
            final /* synthetic */ String $realm;
            final /* synthetic */ JwkProvider $jwkProvider;
            final /* synthetic */ String $issuer;
            final /* synthetic */ String $audience;
            {
                this.$realm = $realm;
                this.$jwkProvider = $jwkProvider;
                this.$issuer = $issuer;
                this.$audience = $audience;
                super(1);
            }

            public final void invoke(@NotNull JWTAuthenticationProvider.Config $this$jwt) {
                Intrinsics.checkNotNullParameter((Object)$this$jwt, (String)"$this$jwt");
                $this$jwt.setRealm(this.$realm);
                JwkProvider jwkProvider = this.$jwkProvider;
                Intrinsics.checkNotNullExpressionValue((Object)jwkProvider, (String)"jwkProvider");
                $this$jwt.verifier(jwkProvider, this.$issuer, (Function1)installJwtAuth.1.INSTANCE);
                $this$jwt.validate((Function3)new Function3<ApplicationCall, JWTCredential, Continuation<? super Principal>, Object>(this.$issuer, this.$audience, null){
                    int label;
                    /* synthetic */ Object L$0;
                    final /* synthetic */ String $issuer;
                    final /* synthetic */ String $audience;
                    {
                        this.$issuer = $issuer;
                        this.$audience = $audience;
                        super(3, $completion);
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                boolean bl;
                                ResultKt.throwOnFailure((Object)object);
                                JWTCredential jwtCredential = (JWTCredential)this.L$0;
                                Object[] objectArray = new Boolean[]{Boxing.boxBoolean((boolean)Intrinsics.areEqual((Object)jwtCredential.getIssuer(), (Object)this.$issuer)), Boxing.boxBoolean((boolean)jwtCredential.getAudience().contains(this.$audience))};
                                Iterable $this$all$iv = CollectionsKt.listOf((Object[])objectArray);
                                boolean $i$f$all = false;
                                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                                    bl = true;
                                } else {
                                    for (T element$iv : $this$all$iv) {
                                        boolean it = (Boolean)element$iv;
                                        boolean bl2 = false;
                                        if (!it) return null;
                                        boolean bl3 = true;
                                        if (bl3) continue;
                                        return null;
                                    }
                                    bl = true;
                                }
                                boolean conditions = bl;
                                if (!conditions) return null;
                                Principal principal = (Principal)new JWTPrincipal(jwtCredential.getPayload());
                                return principal;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @Nullable
                    public final Object invoke(@NotNull ApplicationCall p1, @NotNull JWTCredential p2, @Nullable Continuation<? super Principal> p3) {
                        var var4_4 = new /* invalid duplicate definition of identical inner class */;
                        var4_4.L$0 = p2;
                        return var4_4.invokeSuspend(Unit.INSTANCE);
                    }
                });
            }
        }));
    }
}

