package org.dronda.test.file

import java.io.File

inline fun <reified T> getFileAsByteArray(fileName: String): ByteArray {
    val resource = T::class.java.getResource("${T::class.java.simpleName}/$fileName")
    requireNotNull(resource) { "File: $fileName not found" }
    return File(resource.file)
        .inputStream()
        .readBytes()
}

inline fun <reified T> getFileAsString(fileName: String): String {
    return getFileAsByteArray<T>(fileName).decodeToString()
}
