/*
 * Decompiled with CFR 0.152.
 */
package org.drools.android.roboguice;

import android.app.Application;
import android.content.Context;
import com.google.inject.AbstractModule;
import com.google.inject.Provider;
import java.lang.annotation.Annotation;
import org.drools.android.DroolsAndroidContext;
import org.drools.android.roboguice.KBaseImpl;
import org.drools.android.roboguice.KSessionImpl;
import org.drools.compiler.kie.builder.impl.KieContainerImpl;
import org.drools.compiler.kie.builder.impl.KieProject;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.builder.model.KieBaseModel;
import org.kie.api.builder.model.KieSessionModel;
import org.kie.api.cdi.KContainer;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.StatelessKieSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DroolsContainerModule
extends AbstractModule {
    private static final Logger logger = LoggerFactory.getLogger(DroolsContainerModule.class);
    private Application application;
    private KieServices ks;
    private KieContainerImpl classpathContainer;

    public DroolsContainerModule(Application ctx) {
        this.application = ctx;
    }

    protected void configure() {
        DroolsAndroidContext.setContext((Context)this.application);
        this.ks = KieServices.Factory.get();
        this.classpathContainer = (KieContainerImpl)this.ks.getKieClasspathContainer();
        KieProject kieProject = this.classpathContainer.getKieProject();
        logger.debug("Binding @KContainer");
        this.bind(KieContainer.class).toInstance((Object)this.classpathContainer);
        if (kieProject.getDefaultKieBaseModel() != null) {
            this.bind(KieBase.class).toProvider((Provider)new KBaseProvider(kieProject.getDefaultKieBaseModel(), (KieContainer)this.classpathContainer));
        }
        if (kieProject.getDefaultKieSession() != null) {
            this.bind(KieSession.class).toProvider((Provider)new KSessionProvider(kieProject.getDefaultKieSession(), (KieContainer)this.classpathContainer));
        }
        if (kieProject.getDefaultStatelessKieSession() != null) {
            this.bind(StatelessKieSession.class).toProvider((Provider)new KStatelessSessionProvider(this.classpathContainer.getKieProject().getDefaultStatelessKieSession(), (KieContainer)this.classpathContainer));
        }
        this.bind(KieContainer.class).annotatedWith(KContainer.class).toInstance((Object)this.classpathContainer);
        for (String kbaseName : this.classpathContainer.getKieBaseNames()) {
            logger.debug("Binding @KBase({})", (Object)kbaseName);
            this.bind(KieBase.class).annotatedWith((Annotation)((Object)new KBaseImpl(kbaseName))).toProvider((Provider)new KBaseProvider(this.classpathContainer.getKieBaseModel(kbaseName), (KieContainer)this.classpathContainer));
            for (String ksessionName : this.classpathContainer.getKieSessionNamesInKieBase(kbaseName)) {
                logger.debug("Binding @KSession({})", (Object)ksessionName);
                KieSessionModel model = this.classpathContainer.getKieSessionModel(ksessionName);
                if (model.getType().equals((Object)KieSessionModel.KieSessionType.STATEFUL)) {
                    this.bind(KieSession.class).annotatedWith((Annotation)((Object)new KSessionImpl(ksessionName))).toProvider((Provider)new KSessionProvider(model, (KieContainer)this.classpathContainer));
                    continue;
                }
                this.bind(StatelessKieSession.class).annotatedWith((Annotation)((Object)new KSessionImpl(ksessionName))).toProvider((Provider)new KStatelessSessionProvider(model, (KieContainer)this.classpathContainer));
            }
        }
    }

    private static class KStatelessSessionProvider
    implements Provider<StatelessKieSession> {
        private KieContainer kContainer;
        private final KieSessionModel kSessionModel;

        public KStatelessSessionProvider(KieSessionModel kSessionModel, KieContainer kContainer) {
            this.kSessionModel = kSessionModel;
            this.kContainer = kContainer;
        }

        public StatelessKieSession get() {
            return this.kContainer.newStatelessKieSession(this.kSessionModel.getName());
        }
    }

    private static class KSessionProvider
    implements Provider<KieSession> {
        private KieContainer kContainer;
        private final KieSessionModel kSessionModel;

        public KSessionProvider(KieSessionModel kSessionModel, KieContainer kContainer) {
            this.kSessionModel = kSessionModel;
            this.kContainer = kContainer;
        }

        public KieSession get() {
            return this.kContainer.newKieSession(this.kSessionModel.getName());
        }
    }

    private static class KBaseProvider
    implements Provider<KieBase> {
        private KieContainer kContainer;
        private final KieBaseModel kBaseModel;

        public KBaseProvider(KieBaseModel kBaseModel, KieContainer kContainer) {
            this.kBaseModel = kBaseModel;
            this.kContainer = kContainer;
        }

        public KieBase get() {
            return this.kContainer.getKieBase(this.kBaseModel.getName());
        }
    }
}

