/*
 * Decompiled with CFR 0.152.
 */
package org.drools.android.roboguice;

import android.app.Application;
import android.content.res.Resources;
import com.google.inject.MembersInjector;
import com.google.inject.TypeLiteral;
import com.google.inject.spi.TypeEncounter;
import com.google.inject.spi.TypeListener;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.core.util.DroolsStreamUtils;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.cdi.KBase;
import org.kie.api.runtime.KieContainer;
import org.kie.internal.KnowledgeBase;
import org.kie.internal.KnowledgeBaseFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import roboguice.inject.Nullable;

class KnowledgeBaseListener
implements TypeListener {
    private static final Logger logger = LoggerFactory.getLogger(KnowledgeBaseListener.class);
    protected Application application;
    protected Resources resources;
    private KieServices ks;
    private KieContainer classpathContainer;
    private Map<String, KieBase> kbases = new HashMap<String, KieBase>();

    public KnowledgeBaseListener(Application application) {
        this.application = application;
        this.resources = application.getResources();
    }

    public <I> void hear(TypeLiteral<I> typeLiteral, TypeEncounter<I> typeEncounter) {
        for (Class c = typeLiteral.getRawType(); c != Object.class; c = c.getSuperclass()) {
            for (Field field : c.getDeclaredFields()) {
                if (!field.isAnnotationPresent(KBase.class) || Modifier.isStatic(field.getModifiers())) continue;
                typeEncounter.register(new KnowledgeBaseMembersInjector(field, this.application, field.getAnnotation(KBase.class)));
            }
        }
    }

    protected class KnowledgeBaseMembersInjector<T>
    implements MembersInjector<T> {
        protected Field field;
        protected Application application;
        protected KBase annotation;

        public KnowledgeBaseMembersInjector(Field field, Application application, KBase annotation) {
            this.field = field;
            this.application = application;
            this.annotation = annotation;
        }

        public void injectMembers(T instance) {
            Object knowledgeBase = null;
            try {
                int id = KnowledgeBaseListener.this.resources.getIdentifier(this.annotation.value().toLowerCase(), "raw", this.application.getPackageName());
                logger.debug("Injecting kbase from : " + id);
                if (id != 0) {
                    if (!KnowledgeBaseListener.this.kbases.containsKey(this.annotation.value())) {
                        logger.debug("Deserializing knowledge base {}", (Object)this.annotation.value());
                        knowledgeBase = KnowledgeBaseFactory.newKnowledgeBase();
                        ((KnowledgeBase)knowledgeBase).addKnowledgePackages((Collection)((List)DroolsStreamUtils.streamIn((InputStream)KnowledgeBaseListener.this.resources.openRawResource(id))));
                        KnowledgeBaseListener.this.kbases.put(this.annotation.value(), knowledgeBase);
                    }
                    knowledgeBase = (KieBase)KnowledgeBaseListener.this.kbases.get(this.annotation.value());
                } else {
                    if (KnowledgeBaseListener.this.classpathContainer == null) {
                        KnowledgeBaseListener.this.ks = KieServices.Factory.get();
                        KnowledgeBaseListener.this.classpathContainer = KnowledgeBaseListener.this.ks.getKieClasspathContainer();
                    }
                    knowledgeBase = KnowledgeBaseListener.this.classpathContainer.getKieBase(this.annotation.value());
                }
                if (knowledgeBase == null && Nullable.notNullable((Field)this.field)) {
                    throw new NullPointerException(String.format("Can't inject null value into %s.%s when field is not @Nullable", this.field.getDeclaringClass(), this.field.getName()));
                }
                this.field.setAccessible(true);
                this.field.set(instance, knowledgeBase);
                logger.debug("Injected Knowledge Base: " + knowledgeBase);
            }
            catch (IllegalArgumentException f) {
                throw new IllegalArgumentException(String.format("Can't assign %s value %s to %s field %s", knowledgeBase != null ? knowledgeBase.getClass() : "(null)", knowledgeBase, this.field.getType(), this.field.getName()));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

