/*
 * Decompiled with CFR 0.152.
 */
package org.drools.android;

import com.android.dx.cf.direct.AttributeFactory;
import com.android.dx.cf.direct.DirectClassFile;
import com.android.dx.cf.direct.StdAttributeFactory;
import com.android.dx.dex.DexOptions;
import com.android.dx.dex.cf.CfOptions;
import com.android.dx.dex.cf.CfTranslator;
import com.android.dx.dex.file.DexFile;
import dalvik.system.BaseDexClassLoader;
import dalvik.system.DexClassLoader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.security.ProtectionDomain;
import org.drools.android.DroolsAndroidContext;
import org.drools.core.util.ByteArrayClassLoader;
import org.mvel2.util.MVELClassLoader;
import org.robolectric.annotation.internal.Instrument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Instrument
public class MultiDexClassLoader
extends DexClassLoader
implements ByteArrayClassLoader,
MVELClassLoader {
    private static final Logger log = LoggerFactory.getLogger(MultiDexClassLoader.class);
    private String dexPath = "";
    final DexOptions dex_options = new DexOptions();
    final CfOptions cf_options = new CfOptions();
    private static Field pathListField;
    private static Class dexPathListClazz;
    private static Constructor dexPathListConstructor;

    public MultiDexClassLoader(ClassLoader parent) {
        super(new File(DroolsAndroidContext.getDexDir(), "temp.dex").getAbsolutePath(), DroolsAndroidContext.getOptimizedDir().getAbsolutePath(), DroolsAndroidContext.getContext().getApplicationInfo().nativeLibraryDir, parent != null ? parent : DroolsAndroidContext.getContext().getClassLoader());
        this.dex_options.targetApiLevel = 13;
        this.cf_options.optimize = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String writeClass(String name, byte[] bytes) throws IOException {
        name = name.replace('.', '/');
        File dexFile = new File(String.format("%s/%s.dex", DroolsAndroidContext.getDexDir(), name));
        if (dexFile.exists() && DroolsAndroidContext.isReuseClassFiles()) {
            if (log.isTraceEnabled()) {
                log.trace(String.format("Reused class [%s] from cache: %s", name, dexFile.getAbsolutePath()));
            }
            return dexFile.getAbsolutePath();
        }
        FileOutputStream fos = null;
        try {
            DexFile file = new DexFile(this.dex_options);
            DirectClassFile cf = new DirectClassFile(bytes, name + ".class", this.cf_options.strictNameCheck);
            cf.setAttributeFactory((AttributeFactory)StdAttributeFactory.THE_ONE);
            cf.getMagic();
            file.add(CfTranslator.translate((DirectClassFile)cf, (byte[])bytes, (CfOptions)this.cf_options, (DexOptions)this.dex_options, (DexFile)file));
            dexFile.getParentFile().mkdirs();
            if (dexFile.exists()) {
                dexFile.delete();
            }
            fos = new FileOutputStream(dexFile);
            file.writeTo((OutputStream)fos, null, false);
            if (log.isTraceEnabled()) {
                log.trace(String.format("Wrote class [%s] to cache: %s", name, dexFile.getAbsolutePath()));
            }
            String string = dexFile.getAbsolutePath();
            return string;
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public Class defineClass(String name, byte[] bytes) {
        try {
            String path = this.writeClass(name, bytes);
            this.dexPath = this.dexPath + (this.dexPath.isEmpty() ? "" : ":") + path;
            log.trace("New Dexpath: " + this.dexPath);
            pathListField.set((Object)this, dexPathListConstructor.newInstance(new Object[]{this, path, DroolsAndroidContext.getContext().getApplicationInfo().nativeLibraryDir, DroolsAndroidContext.getOptimizedDir()}));
            return this.findClass(name);
        }
        catch (Exception e) {
            log.error("Error", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public Class<?> defineClass(String name, byte[] bytes, ProtectionDomain domain) {
        return this.defineClass(name, bytes);
    }

    public Class defineClassX(String className, byte[] b, int start, int len) {
        byte[] newBytes = new byte[len];
        System.arraycopy(b, start, newBytes, 0, len);
        return this.defineClass(className, newBytes);
    }

    public String toString() {
        try {
            return ((Object)((Object)this)).getClass().getName() + "[" + pathListField.get((Object)this) + "]";
        }
        catch (IllegalAccessException e) {
            return super.toString();
        }
    }

    static {
        try {
            dexPathListClazz = Class.forName("dalvik.system.DexPathList");
            dexPathListConstructor = dexPathListClazz.getConstructor(ClassLoader.class, String.class, String.class, File.class);
            pathListField = BaseDexClassLoader.class.getDeclaredField("pathList");
            pathListField.setAccessible(true);
        }
        catch (Exception e) {
            log.error("Reflection error", (Throwable)e);
        }
    }
}

