/*
 * Decompiled with CFR 0.152.
 */
package org.drools.builder;

import java.util.Properties;
import org.drools.KnowledgeBase;
import org.drools.builder.DecisionTableConfiguration;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderConfiguration;
import org.drools.builder.KnowledgeBuilderFactoryService;
import org.drools.util.ServiceRegistryImpl;

public class KnowledgeBuilderFactory {
    private static volatile KnowledgeBuilderFactoryService factoryService;

    public static KnowledgeBuilder newKnowledgeBuilder() {
        return KnowledgeBuilderFactory.getKnowledgeBuilderPServiceFactory().newKnowledgeBuilder();
    }

    public static KnowledgeBuilder newKnowledgeBuilder(KnowledgeBuilderConfiguration conf) {
        return KnowledgeBuilderFactory.getKnowledgeBuilderPServiceFactory().newKnowledgeBuilder(conf);
    }

    public static KnowledgeBuilder newKnowledgeBuilder(KnowledgeBase kbase) {
        return KnowledgeBuilderFactory.getKnowledgeBuilderPServiceFactory().newKnowledgeBuilder(kbase);
    }

    public static KnowledgeBuilder newKnowledgeBuilder(KnowledgeBase kbase, KnowledgeBuilderConfiguration conf) {
        return KnowledgeBuilderFactory.getKnowledgeBuilderPServiceFactory().newKnowledgeBuilder(kbase, conf);
    }

    public static KnowledgeBuilderConfiguration newKnowledgeBuilderConfiguration() {
        return KnowledgeBuilderFactory.getKnowledgeBuilderPServiceFactory().newKnowledgeBuilderConfiguration();
    }

    public static KnowledgeBuilderConfiguration newKnowledgeBuilderConfiguration(Properties properties, ClassLoader classLoader) {
        return KnowledgeBuilderFactory.getKnowledgeBuilderPServiceFactory().newKnowledgeBuilderConfiguration(properties, classLoader);
    }

    public static DecisionTableConfiguration newDecisionTableConfiguration() {
        return KnowledgeBuilderFactory.getKnowledgeBuilderPServiceFactory().newDecisionTableConfiguration();
    }

    private static synchronized void setKnowledgeBuilderFactoryService(KnowledgeBuilderFactoryService serviceFactory) {
        factoryService = serviceFactory;
    }

    private static synchronized KnowledgeBuilderFactoryService getKnowledgeBuilderPServiceFactory() {
        if (factoryService == null) {
            KnowledgeBuilderFactory.loadServiceFactory();
        }
        return factoryService;
    }

    private static void loadServiceFactory() {
        KnowledgeBuilderFactory.setKnowledgeBuilderFactoryService(ServiceRegistryImpl.getInstance().get(KnowledgeBuilderFactoryService.class));
    }
}

