/*
 * Decompiled with CFR 0.152.
 */
package org.drools.grid;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecutionNode {
    private String id;
    private final Map<Class<?>, Object> services = new ConcurrentHashMap();

    public ExecutionNode() {
        this.id = UUID.randomUUID().toString();
    }

    public ExecutionNode(String id) {
        this.id = id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T get(Class<T> interfaceClass) {
        Class<T> clazz = interfaceClass;
        synchronized (clazz) {
            Object service = this.services.get(interfaceClass);
            if (service == null) {
                try {
                    Class<?> implementingClass = Class.forName(String.valueOf(interfaceClass.getCanonicalName()) + "Impl");
                    service = implementingClass.newInstance();
                    this.services.put(interfaceClass, service);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            return interfaceClass.cast(service);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void set(Class<T> interfaceClass, T provider) {
        Class<T> clazz = interfaceClass;
        synchronized (clazz) {
            this.services.put(interfaceClass, provider);
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }
}

