/*
 * Decompiled with CFR 0.152.
 */
package org.drools.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeClassLoader
extends ClassLoader {
    private final List<ClassLoader> classLoaders = new CopyOnWriteArrayList<ClassLoader>();
    private final AtomicReference<Loader> loader = new AtomicReference();

    public CompositeClassLoader(ClassLoader parentClassLoader) {
        super(null);
        this.loader.set(new DefaultLoader());
    }

    public synchronized void setCachingEnabled(boolean enabled) {
        if (enabled && this.loader.get() instanceof DefaultLoader) {
            this.loader.set(new CachingLoader());
        } else if (!enabled && this.loader.get() instanceof CachingLoader) {
            this.loader.set(DefaultLoader.INSTANCE);
        }
    }

    public synchronized void addClassLoader(ClassLoader classLoader) {
        for (ClassLoader cl : this.classLoaders) {
            if (cl != classLoader) continue;
            return;
        }
        this.classLoaders.add(classLoader);
        this.loader.get().reset();
    }

    public synchronized void removeClassLoader(ClassLoader classLoader) {
        this.classLoaders.remove(classLoader);
        this.loader.get().reset();
    }

    @Override
    public Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        return this.loader.get().load(this, name, resolve);
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        for (ClassLoader classLoader : this.classLoaders) {
            InputStream stream = classLoader.getResourceAsStream(name);
            if (stream == null) continue;
            return stream;
        }
        return null;
    }

    @Override
    public URL getResource(String name) {
        for (ClassLoader classLoader : this.classLoaders) {
            URL url = classLoader.getResource(name);
            if (url == null) continue;
            return url;
        }
        return null;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        CompositeEnumeration<URL> enumerations = new CompositeEnumeration<URL>();
        for (ClassLoader classLoader : this.classLoaders) {
            Enumeration<URL> e = classLoader.getResources(name);
            if (e == null) continue;
            enumerations.addEnumeration(e);
        }
        if (enumerations.size() == 0) {
            return null;
        }
        return enumerations;
    }

    public void dumpStats() {
        System.out.println(this.loader.toString());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CachingLoader
    implements Loader {
        private final Map<String, Object> classLoaderResultMap = new HashMap<String, Object>();
        public long successfulCalls = 0L;
        public long failedCalls = 0L;
        public long cacheHits = 0L;

        private CachingLoader() {
        }

        @Override
        public Class<?> load(CompositeClassLoader cl, String name, boolean resolve) {
            if (this.classLoaderResultMap.containsKey(name)) {
                ++this.cacheHits;
                return (Class)this.classLoaderResultMap.get(name);
            }
            Class<?> cls = null;
            for (ClassLoader classLoader : cl.classLoaders) {
                try {
                    cls = Class.forName(name, true, classLoader);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                if (cls != null) break;
            }
            if (resolve) {
                cl.resolveClass(cls);
            }
            this.classLoaderResultMap.put(name, cls);
            if (cls != null) {
                ++this.successfulCalls;
            } else {
                ++this.failedCalls;
            }
            return cls;
        }

        @Override
        public void reset() {
            this.cacheHits = 0L;
            this.failedCalls = 0L;
            this.successfulCalls = 0L;
        }

        public String toString() {
            return "TotalCalls: " + (this.successfulCalls + this.failedCalls + this.cacheHits) + " CacheHits: " + this.cacheHits + " successfulCalls: " + this.successfulCalls + " FailedCalls: " + this.failedCalls;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CompositeEnumeration<URL>
    implements Enumeration<URL> {
        private List<URL> list;
        private Iterator<URL> it;

        private CompositeEnumeration() {
        }

        public void addEnumeration(Enumeration<URL> enumeration) {
            if (!enumeration.hasMoreElements()) {
                return;
            }
            if (this.it != null) {
                throw new IllegalStateException("cannot add more enumerations while iterator");
            }
            if (this.list == null) {
                this.list = new ArrayList<URL>();
            }
            while (enumeration.hasMoreElements()) {
                this.list.add(enumeration.nextElement());
            }
        }

        public int size() {
            if (this.list == null) {
                return 0;
            }
            return this.list.size();
        }

        @Override
        public boolean hasMoreElements() {
            if (this.it == null) {
                if (this.list == null) {
                    return false;
                }
                this.it = this.list.iterator();
            }
            return this.it.hasNext();
        }

        @Override
        public URL nextElement() {
            if (this.it == null) {
                if (this.list == null) {
                    throw new NoSuchElementException();
                }
                this.it = this.list.iterator();
            }
            return this.it.next();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DefaultLoader
    implements Loader {
        public static final DefaultLoader INSTANCE = new DefaultLoader();

        private DefaultLoader() {
        }

        @Override
        public Class<?> load(CompositeClassLoader cl, String name, boolean resolve) {
            Class<?> cls = null;
            for (ClassLoader classLoader : cl.classLoaders) {
                try {
                    cls = Class.forName(name, true, classLoader);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                if (cls != null) break;
            }
            if (resolve) {
                cl.resolveClass(cls);
            }
            return cls;
        }

        @Override
        public void reset() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface Loader {
        public Class<?> load(CompositeClassLoader var1, String var2, boolean var3);

        public void reset();
    }
}

