/*
 * Decompiled with CFR 0.152.
 */
package org.drools.assistant.engine;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.drools.assistant.engine.AbstractParserEngine;
import org.drools.assistant.info.RuleRefactorInfo;
import org.drools.assistant.info.drl.DRLContentTypeEnum;
import org.drools.assistant.info.drl.DRLRuleRefactorInfo;
import org.drools.assistant.info.drl.RuleLineContentInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DRLParserEngine
extends AbstractParserEngine {
    private static final String RULE_DECLARATION = "(rule|RULE)";
    private static final String PACKAGE_DECLARATION = "(package|PACKAGE)";
    private static final String IMPORT_DECLARATION = "(import|IMPORT)";
    private static final String GLOBAL_DECLARATION = "(global|GLOBAL)";
    private static final String RULE_WHEN_DECLARATION = "(when|WHEN)";
    private static final String RULE_THEN_DECLARATION = "(then|THEN)";
    private static final String RULE_END_DECLARATION = "(end|END)";
    private static final String OPTIONAL_TAB = "[\t]*";
    private static final String FULLY_QUALIFIED_NAME = "[\\w\\.]*";
    private static final String ONE_OR_MORE_SPACES = "[\\s]+";
    private static final String RULE_NAME = "\"[\\s\\w]*\"";
    private static final String PACKAGE_PATTERN = "(package|PACKAGE)[\\s]+[\\w\\.]*;?";
    private static final String IMPORT_PATTERN = "(import|IMPORT)[\\s]+[\\w\\.]*;";
    private static final String GLOBAL_PATTERN = "(global|GLOBAL)[\\s]+[\\w\\.]*[\\s]+[\\w]*[\\s]+";
    private static final String RULE_NAME_PATTERN = "(rule|RULE)[\\s]+\"[\\s\\w]*\"";
    private static final String RULE_LHS_PATTERN = "[\\t\\s]*(when|WHEN)[\\s]+[\t]*[\\w\\W]*(?=(then|THEN))";
    private static final String RULE_RHS_PATTERN = "[\\t\\s]*(then|THEN)[\\s]+[\\w\\W]*(end|END)";
    private static final Pattern rulePattern = Pattern.compile("rule.+?end\\s*$", 40);

    public DRLParserEngine(String rule) {
        this.ruleRefactorInfo = new DRLRuleRefactorInfo();
        this.rule = rule;
    }

    @Override
    public RuleRefactorInfo parse() {
        this.detectPackage(this.rule);
        this.detectGlobals(this.rule);
        this.detectImports(this.rule);
        this.detectRules(this.rule);
        return this.ruleRefactorInfo;
    }

    private void detectPackage(CharSequence rule) {
        this.pattern = Pattern.compile(PACKAGE_PATTERN);
        this.matcher = this.pattern.matcher(rule);
        if (this.matcher.find()) {
            ((DRLRuleRefactorInfo)this.ruleRefactorInfo).addContent(DRLContentTypeEnum.PACKAGE, this.matcher.start(), this.matcher.group());
        }
    }

    private void detectImports(CharSequence rule) {
        this.pattern = Pattern.compile(IMPORT_PATTERN);
        this.matcher = this.pattern.matcher(rule);
        while (this.matcher.find()) {
            ((DRLRuleRefactorInfo)this.ruleRefactorInfo).addContent(DRLContentTypeEnum.IMPORT, this.matcher.start(), this.matcher.group());
        }
    }

    private void detectGlobals(CharSequence rule) {
        this.pattern = Pattern.compile(GLOBAL_PATTERN);
        this.matcher = this.pattern.matcher(rule);
        while (this.matcher.find()) {
            ((DRLRuleRefactorInfo)this.ruleRefactorInfo).addContent(DRLContentTypeEnum.GLOBAL, this.matcher.start(), this.matcher.group());
        }
    }

    private void detectRules(CharSequence rule) {
        Matcher ruleMatcher = rulePattern.matcher(rule);
        while (ruleMatcher.find()) {
            for (int position = 0; position < ruleMatcher.groupCount() + 1; ++position) {
                String value = ruleMatcher.group(position);
                int offset = ruleMatcher.start();
                String ruleName = this.detectRuleName(value);
                List<RuleLineContentInfo> lhs = this.detectLHS(value, offset);
                lhs.remove(lhs.size() - 1);
                List<RuleLineContentInfo> rhs = this.detectRHS(value, offset);
                ((DRLRuleRefactorInfo)this.ruleRefactorInfo).addContent(DRLContentTypeEnum.RULE, offset, value, ruleName, lhs, rhs);
            }
        }
    }

    private String detectRuleName(CharSequence rule) {
        this.pattern = Pattern.compile(RULE_NAME_PATTERN);
        this.matcher = this.pattern.matcher(rule);
        if (this.matcher.find()) {
            return this.matcher.group();
        }
        return null;
    }

    private List<RuleLineContentInfo> detectLHS(CharSequence rule, int ruleOffset) {
        this.pattern = Pattern.compile(RULE_LHS_PATTERN);
        this.matcher = this.pattern.matcher(rule);
        if (this.matcher.find()) {
            return this.detectLines(this.matcher.group(), this.matcher.start() + ruleOffset, DRLContentTypeEnum.RULE_LHS_LINE);
        }
        return null;
    }

    private List<RuleLineContentInfo> detectRHS(CharSequence rule, int ruleOffset) {
        this.pattern = Pattern.compile(RULE_RHS_PATTERN);
        this.matcher = this.pattern.matcher(rule);
        if (this.matcher.find()) {
            return this.detectLines(this.matcher.group(), this.matcher.start() + ruleOffset, DRLContentTypeEnum.RULE_RHS_LINE);
        }
        return null;
    }

    private List<RuleLineContentInfo> detectLines(CharSequence rule, int lineOffset, DRLContentTypeEnum type) {
        ArrayList<RuleLineContentInfo> ruleLines = new ArrayList<RuleLineContentInfo>();
        this.pattern = Pattern.compile(".*");
        this.matcher = this.pattern.matcher(rule);
        while (this.matcher.find()) {
            if (this.matcher.start() == this.matcher.end()) continue;
            ruleLines.add(new RuleLineContentInfo(this.matcher.start() + lineOffset, this.matcher.group(), type));
        }
        return ruleLines;
    }
}

