/*
 * Decompiled with CFR 0.152.
 */
package org.drools.assistant.refactor.drl;

import org.drools.assistant.info.drl.RuleBasicContentInfo;
import org.drools.assistant.refactor.drl.Variable;

public class VariableBinding
extends Variable {
    private static final String DEFAULT_VARIABLE_NAME = "$default";

    public static String execute(RuleBasicContentInfo contentInfo, int offset) {
        VariableBinding.detectCurrentVariables(contentInfo);
        return VariableBinding.execute(contentInfo.getContent(), offset);
    }

    public static String execute(String line, int offset) {
        int position;
        if (offset > line.length()) {
            return line;
        }
        for (position = offset - 1; position >= 0; --position) {
            if (line.charAt(position) != ' ' && line.charAt(position) != '(' && line.charAt(position) != '\t' && line.charAt(position) != ',') continue;
            String left = line.substring(0, position + 1);
            String right = line.substring(position + 1, line.length());
            if (!VariableBinding.isVariableOrParameter(right, left) && !VariableBinding.hasVariableAssigned(left)) {
                return left + VariableBinding.getVariableName(right) + right;
            }
            return line;
        }
        for (position = 0; position < line.length(); ++position) {
            if (line.charAt(position) == ':') {
                return line;
            }
            if (line.charAt(position) != '(' && line.charAt(position) != ',') continue;
            return VariableBinding.getVariableName(line) + line;
        }
        return line;
    }

    private static boolean isVariableOrParameter(String right, String left) {
        int position;
        for (position = 0; position <= right.length() - 1 && right.charAt(position) != ',' && right.charAt(position) != '('; ++position) {
            if (right.charAt(position) != ':') continue;
            return true;
        }
        for (position = left.length() - 1; position >= 0; --position) {
            if (left.charAt(position) == '>' || left.charAt(position) == '<' || left.charAt(position) == '=') {
                return true;
            }
            if (left.charAt(position) != ',') continue;
            return false;
        }
        return false;
    }

    private static String getVariableName(String right) {
        for (int position = 0; position < right.length(); ++position) {
            if (right.charAt(position) != '(' && right.charAt(position) != ')' && right.charAt(position) != ',' && right.charAt(position) != '<' && right.charAt(position) != '>' && right.charAt(position) != '=') continue;
            String varname = "$" + right.substring(0, position).toLowerCase().trim();
            return VariableBinding.generateVariableName(varname);
        }
        return DEFAULT_VARIABLE_NAME;
    }

    private static boolean hasVariableAssigned(String line) {
        for (int position = line.length() - 1; position >= 0; --position) {
            if (line.charAt(position) == ':') {
                return true;
            }
            if (line.charAt(position) != ',' && line.charAt(position) != '(') continue;
            return false;
        }
        return false;
    }

    private static String generateVariableName(String varname) {
        if (!VariableBinding.existsVariableWithSameName(varname)) {
            return varname + " : ";
        }
        for (int count = 1; count <= 100; ++count) {
            if (VariableBinding.existsVariableWithSameName(varname + count)) continue;
            return varname + count + " : ";
        }
        return varname;
    }
}

