/*
 * Decompiled with CFR 0.152.
 */
package org.drools.benchmark.benchmarks;

import org.drools.KnowledgeBase;
import org.drools.benchmark.BenchmarkDefinition;
import org.drools.benchmark.benchmarks.AbstractBenchmark;
import org.drools.benchmark.model.DummyBean;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.runtime.rule.FactHandle;

public class InsertAllAndRetract
extends AbstractBenchmark {
    private final int objectsNumber;
    private String[] drlFiles;
    private FactHandle[] facts;
    private StatefulKnowledgeSession ksession;

    public InsertAllAndRetract(int objectsNumber) {
        this.objectsNumber = objectsNumber;
    }

    public InsertAllAndRetract(int objectsNumber, String drlFile) {
        this(objectsNumber);
        this.drlFiles = drlFile.split(",");
    }

    public void init(BenchmarkDefinition definition) {
        KnowledgeBase kbase = this.createKnowledgeBase(this.createKnowledgeBuilder(this.drlFiles));
        this.ksession = kbase.newStatefulKnowledgeSession();
        this.facts = new FactHandle[this.objectsNumber];
    }

    public void execute(int repNr) {
        for (int i = 0; i < this.objectsNumber; ++i) {
            this.facts[i] = this.ksession.insert((Object)new DummyBean(i));
        }
        this.ksession.fireAllRules();
        for (FactHandle fact : this.facts) {
            this.ksession.retract(fact);
        }
        this.ksession.fireAllRules();
    }

    public void terminate() {
        this.ksession.dispose();
    }
}

