/*
 * Decompiled with CFR 0.152.
 */
package org.drools.benchmark.benchmarks;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import org.drools.benchmark.BenchmarkDefinition;
import org.drools.benchmark.benchmarks.AbstractBenchmark;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.ResourceType;
import org.drools.io.ResourceFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuleCompile
extends AbstractBenchmark {
    private String[] drlFiles;
    private Map<String, String[]> drls;
    private KnowledgeBuilder kbuilder;

    public RuleCompile(String drlFile) {
        this.drlFiles = drlFile.split(",");
    }

    @Override
    public void init(BenchmarkDefinition definition) {
        this.drls = this.prepareDrls(definition.getRepetitions());
        this.kbuilder = this.createKnowledgeBuilder(this.drlFiles);
    }

    private Map<String, String[]> prepareDrls(int repetitions) {
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        for (String drlFile : this.drlFiles) {
            String drl = this.readFile(drlFile);
            String[] drls = new String[repetitions];
            for (int i = 0; i < drls.length; ++i) {
                drls[i] = drl.replaceAll("\\_", "" + i);
            }
            map.put(drlFile, drls);
        }
        return map;
    }

    private String readFile(String fileName) {
        StringBuilder sb = new StringBuilder();
        InputStreamReader isr = null;
        BufferedReader br = null;
        try {
            isr = new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream(fileName));
            br = new BufferedReader(isr);
            String line = br.readLine();
            while (line != null) {
                sb.append(line).append(this.LINE_SEPARATOR);
                line = br.readLine();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
                if (isr != null) {
                    isr.close();
                }
            }
            catch (Exception e) {}
        }
        return sb.toString();
    }

    @Override
    public void execute(int repNr) {
        for (String drlFile : this.drlFiles) {
            String drl = this.drls.get(drlFile)[repNr];
            this.kbuilder.add(ResourceFactory.newByteArrayResource((byte[])drl.getBytes()), ResourceType.DRL);
            if (!this.kbuilder.hasErrors()) continue;
            System.err.println(drl);
            throw new RuntimeException(this.kbuilder.getErrors().toString());
        }
    }
}

