/*
 * Decompiled with CFR 0.152.
 */
package org.drools.benchmark;

import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import org.drools.benchmark.BenchmarkDefinition;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BenchmarkConfig
implements Iterable<BenchmarkDefinition> {
    private List<BenchmarkDefinition> benchmarks;
    private int delay = 1;
    private int repetitions = 1;

    public BenchmarkConfig(String configFile) {
        this.benchmarks = this.parse(configFile);
    }

    @Override
    public Iterator<BenchmarkDefinition> iterator() {
        return this.benchmarks.iterator();
    }

    public int getDelay() {
        return this.delay;
    }

    public int getRepetitions() {
        return this.repetitions;
    }

    private List<BenchmarkDefinition> parse(String configFile) {
        try {
            InputStream xmlStream = this.getClass().getClassLoader().getResourceAsStream(configFile);
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(xmlStream);
            Element root = doc.getDocumentElement();
            root.normalize();
            this.parseRootAttrs(root);
            return this.parseBenchmarks(root);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void parseRootAttrs(Element root) throws Exception {
        this.delay = this.getAttributeValueAsInt(root, "delay", 1);
        this.repetitions = this.getAttributeValueAsInt(root, "repetitions", 1);
    }

    private List<BenchmarkDefinition> parseBenchmarks(Element root) throws Exception {
        NodeList nodes = root.getElementsByTagName("benchmark");
        ArrayList<BenchmarkDefinition> bs = new ArrayList<BenchmarkDefinition>(nodes.getLength());
        for (int i = 0; i < nodes.getLength(); ++i) {
            bs.add(this.parse((Element)nodes.item(i)));
        }
        return bs;
    }

    private BenchmarkDefinition parse(Element element) throws ClassNotFoundException, InvocationTargetException, IllegalAccessException, InstantiationException {
        String className = element.getAttribute("classname");
        List<String> args = this.getTagValues(element, "arg");
        Constructor<?> constructor = this.getConstructorForArgs(className, args);
        String description = element.getAttribute("description");
        String en = element.getAttribute("enabled");
        boolean enabled = en.isEmpty() || !en.trim().toLowerCase().equals("false");
        return new BenchmarkDefinition(constructor, this.toArgs(constructor.getParameterTypes(), args)).setDescription(description).setRepetitions(this.getAttributeValueAsInt(element, "repetitions", 1)).setWarmups(this.getAttributeValueAsInt(element, "warmups", 0)).setEnabled(enabled);
    }

    private Constructor<?> getConstructorForArgs(String className, List<String> args) throws ClassNotFoundException {
        Class<?> clazz = Class.forName(className);
        for (Constructor<?> c : clazz.getConstructors()) {
            if (c.getParameterTypes().length != args.size()) continue;
            return c;
        }
        throw new RuntimeException("Unable to find a constructor for class " + className + " with the given arguments: " + args);
    }

    private Object[] toArgs(Class<?>[] types, List<String> args) {
        Object[] objs = new Object[types.length];
        for (int i = 0; i < types.length; ++i) {
            objs[i] = this.toArg(types[i], args.get(i));
        }
        return objs;
    }

    private Object toArg(Class<?> type, String arg) {
        if (type == Integer.class || type == Integer.TYPE) {
            return Integer.parseInt(arg);
        }
        return arg;
    }

    private List<String> getTagValues(Element element, String name) {
        LinkedList<String> values = new LinkedList<String>();
        NodeList children = element.getElementsByTagName(name);
        for (int i = 0; i < children.getLength(); ++i) {
            values.add(children.item(i).getFirstChild().getNodeValue());
        }
        return values;
    }

    private int getAttributeValueAsInt(Element elem, String name, int def) {
        String value = elem.getAttribute(name);
        return value.isEmpty() ? def : Integer.parseInt(value);
    }
}

