/*
 * Decompiled with CFR 0.152.
 */
package org.drools.benchmark;

import java.util.concurrent.Callable;
import org.drools.benchmark.util.DroolsUtil;
import org.drools.benchmark.util.MemoryUtil;
import org.kie.KnowledgeBase;

public class ObjectSizeCalculator {
    private static final int INSTANCES_NR = 10000;
    private static final Callable<Object> OBJECT_GENERATOR = new StatlessSessionGenerator();

    public static void main(String[] args) {
        long size = new ObjectSizeCalculator().calcSize();
        System.out.println(size);
    }

    private long calcSize() {
        Object[] objs = new Object[10000];
        MemoryUtil.aggressiveGC(10);
        long startMemoryUse = MemoryUtil.usedMemory();
        try {
            for (int i = 0; i < 10000; ++i) {
                objs[i] = OBJECT_GENERATOR.call();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        MemoryUtil.aggressiveGC(10);
        long endMemoryUse = MemoryUtil.usedMemory();
        return (endMemoryUse - startMemoryUse) / 10000L;
    }

    private static class StatlessSessionGenerator
    implements Callable<Object> {
        private KnowledgeBase kbase = DroolsUtil.createKnowledgeBase(DroolsUtil.createKnowledgeBuilder(this, "licenseApplication.drl"));
        private int idCounter = 0;

        @Override
        public Object call() throws Exception {
            return this.kbase.newStatefulKnowledgeSession();
        }
    }
}

