/*
 * Decompiled with CFR 0.152.
 */
package org.drools.benchmark.benchmarks;

import org.drools.benchmark.BenchmarkDefinition;
import org.drools.benchmark.benchmarks.AbstractBenchmark;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.internal.KnowledgeBase;
import org.kie.internal.runtime.StatefulKnowledgeSession;

public class InsertAllAndRetract
extends AbstractBenchmark {
    private static StatefulKnowledgeSession ksession;
    private String[] drlFiles;
    private final int objectsNumber;
    private FactHandle[] facts;

    public InsertAllAndRetract(int objectsNumber) {
        this.objectsNumber = objectsNumber;
    }

    public InsertAllAndRetract(int objectsNumber, String drlFile) {
        this(objectsNumber);
        this.drlFiles = drlFile.split(",");
    }

    @Override
    public void init(BenchmarkDefinition definition, boolean isFirst) {
        if (isFirst) {
            KnowledgeBase kbase = this.createKnowledgeBase(this.createKnowledgeBuilder(this.drlFiles));
            ksession = kbase.newStatefulKnowledgeSession();
        }
        this.facts = new FactHandle[this.objectsNumber];
    }

    @Override
    public void execute(int repNr) {
        for (int i = 0; i < this.objectsNumber; ++i) {
            this.facts[i] = ksession.insert((Object)new Integer(i));
        }
        ksession.fireAllRules();
        for (FactHandle fact : this.facts) {
            ksession.retract(fact);
        }
        ksession.fireAllRules();
    }

    @Override
    public void terminate(boolean isLast) {
        if (isLast) {
            ksession.dispose();
        }
    }

    @Override
    public InsertAllAndRetract clone() {
        InsertAllAndRetract clone = new InsertAllAndRetract(this.objectsNumber);
        clone.drlFiles = this.drlFiles;
        return clone;
    }
}

