/*
 * Decompiled with CFR 0.152.
 */
package org.drools.benchmark;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.drools.benchmark.Benchmark;
import org.drools.benchmark.BenchmarkConfig;
import org.drools.benchmark.BenchmarkDefinition;
import org.drools.benchmark.BenchmarkResult;
import org.drools.benchmark.ResultsAccumulator;
import org.drools.benchmark.util.MemoryUtil;

public class BenchmarkRunner {
    private static final String CONFIG_FILE = "benchmark.xml";
    private final Executor executor = Executors.newCachedThreadPool(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r);
            t.setDaemon(true);
            return t;
        }
    });

    public static void main(String[] args) {
        new BenchmarkRunner().run();
    }

    private void run() {
        long start = System.nanoTime();
        BenchmarkConfig config = new BenchmarkConfig(CONFIG_FILE);
        ArrayList<List<BenchmarkResult>> results = new ArrayList<List<BenchmarkResult>>();
        for (int i = 0; i < config.getRepetitions(); ++i) {
            results.add(this.executeAll(config, i));
        }
        this.printResults(this.accumulateResults(results));
        System.out.println("\nDone in " + (System.nanoTime() - start) / 1000000L + " msecs");
    }

    private void printResults(List<ResultsAccumulator> results) {
        System.out.println("Benchmark Description;Min Duration;Max Duration;Avg Duration;Min Used Memory;Max Used Memory;Avg Used Memory");
        for (ResultsAccumulator result : results) {
            System.out.println(result);
        }
    }

    private List<ResultsAccumulator> accumulateResults(List<List<BenchmarkResult>> results) {
        int benchmarksNr = results.get(0).size();
        ArrayList<ResultsAccumulator> accumulatedResults = new ArrayList<ResultsAccumulator>();
        for (int i = 0; i < benchmarksNr; ++i) {
            ResultsAccumulator accumulator = new ResultsAccumulator();
            for (List<BenchmarkResult> runResults : results) {
                accumulator.accumulate(runResults.get(i));
            }
            accumulatedResults.add(accumulator);
        }
        return accumulatedResults;
    }

    private List<BenchmarkResult> executeAll(BenchmarkConfig config, int execNr) {
        ArrayList<BenchmarkResult> results = new ArrayList<BenchmarkResult>();
        for (BenchmarkDefinition benchmarkDef : config) {
            if (!benchmarkDef.isEnabled()) continue;
            BenchmarkResult result = this.execute(config, benchmarkDef, execNr == 0);
            System.out.println(result);
            results.add(result);
        }
        MemoryUtil.aggressiveGC(config.getDelay());
        return results;
    }

    private BenchmarkResult execute(BenchmarkConfig config, BenchmarkDefinition definition, boolean shouldWarmUp) {
        Benchmark benchmark = definition.instance();
        this.warmUpExecution(config, definition, benchmark, shouldWarmUp);
        MemoryUtil.aggressiveGC(config.getDelay());
        BenchmarkResult result = new BenchmarkResult(definition);
        result.setUsedMemoryBeforeStart(MemoryUtil.usedMemory());
        System.out.println("Executing: " + definition);
        result.setDuration(this.executeBenchmark(definition, benchmark));
        MemoryUtil.aggressiveGC(config.getDelay());
        result.setUsedMemoryAfterEnd(MemoryUtil.usedMemory());
        benchmark = null;
        MemoryUtil.aggressiveGC(config.getDelay());
        result.setUsedMemoryAfterGC(MemoryUtil.usedMemory());
        return result;
    }

    private void warmUpExecution(BenchmarkConfig config, BenchmarkDefinition definition, Benchmark benchmark, boolean shouldWarmUp) {
        int warmups;
        int n = shouldWarmUp ? definition.getWarmups() : (warmups = definition.isForceWarmup() ? 1 : 0);
        if (warmups < 1) {
            return;
        }
        System.out.println("Warming up: " + definition.getDescription());
        benchmark.init(definition);
        for (int i = 0; i < warmups; ++i) {
            benchmark.execute(0);
        }
        benchmark.terminate();
        MemoryUtil.aggressiveGC(config.getDelay());
    }

    private long executeBenchmark(BenchmarkDefinition definition, Benchmark benchmark) {
        return definition.isParallel() ? this.executeMultiThreadedBenchmark(definition, benchmark) : this.executeSingleThreadedBenchmark(definition, benchmark);
    }

    private long executeSingleThreadedBenchmark(BenchmarkDefinition definition, Benchmark benchmark) {
        benchmark.init(definition);
        long elapsed = this.runBenchmark(definition, benchmark);
        benchmark.terminate();
        return elapsed;
    }

    private long executeMultiThreadedBenchmark(final BenchmarkDefinition definition, Benchmark benchmark) {
        int i;
        Benchmark[] benchmarks = new Benchmark[definition.getThreadNr()];
        for (int i2 = 0; i2 < definition.getThreadNr(); ++i2) {
            benchmarks[i2] = benchmark.clone();
            benchmarks[i2].init(definition, i2 == 0);
        }
        ExecutorCompletionService<Long> ecs = new ExecutorCompletionService<Long>(this.executor);
        for (int i3 = 0; i3 < definition.getThreadNr(); ++i3) {
            final Benchmark b = benchmarks[i3];
            ecs.submit(new Callable<Long>(){

                @Override
                public Long call() throws Exception {
                    return BenchmarkRunner.this.runBenchmark(definition, b);
                }
            });
        }
        long result = 0L;
        for (i = 0; i < definition.getThreadNr(); ++i) {
            try {
                result += ((Long)ecs.take().get()).longValue();
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        for (i = 0; i < definition.getThreadNr(); ++i) {
            benchmarks[i].terminate(i == definition.getThreadNr() - 1);
        }
        return result / (long)definition.getThreadNr();
    }

    private long runBenchmark(BenchmarkDefinition definition, Benchmark benchmark) {
        long start = System.nanoTime();
        for (int i = 0; i < definition.getRepetitions(); ++i) {
            benchmark.execute(i);
        }
        return (System.nanoTime() - start) / 1000000L;
    }
}

