/*
 * Decompiled with CFR 0.152.
 */
package org.drools.benchmark.benchmarks;

import java.util.Random;
import org.drools.benchmark.BenchmarkDefinition;
import org.drools.benchmark.benchmarks.AbstractBenchmark;
import org.drools.benchmark.model.Fire;
import org.drools.benchmark.model.Room;
import org.drools.benchmark.model.Sprinkler;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.FactHandle;

public class FireAlarmBenchmark
extends AbstractBenchmark {
    private final int roomsNumber;
    private String[] drlFile;
    private KieSession ksession;
    private Room[] rooms;
    private Random random = new Random();

    public FireAlarmBenchmark(int roomsNumber, String drlFile) {
        this.roomsNumber = roomsNumber;
        this.drlFile = drlFile.split(",");
    }

    @Override
    public void init(BenchmarkDefinition definition) {
        KieBase kbase = this.createKnowledgeBase(this.createKnowledgeBuilder(this.drlFile));
        this.ksession = kbase.newKieSession();
        this.rooms = new Room[this.roomsNumber];
        for (int i = 0; i < this.roomsNumber; ++i) {
            Room room = new Room("Room" + i);
            this.ksession.insert((Object)room);
            Sprinkler sprinkler = new Sprinkler(room);
            this.ksession.insert((Object)sprinkler);
            this.rooms[i] = room;
        }
    }

    @Override
    public void execute(int repNr) {
        int roomNr = this.random.nextInt(this.roomsNumber);
        FactHandle fact = this.ksession.insert((Object)new Fire(this.rooms[roomNr]));
        this.ksession.fireAllRules();
        this.ksession.retract(fact);
        this.ksession.fireAllRules();
    }

    @Override
    public void terminate() {
        this.ksession.dispose();
    }
}

