/*
 * Copyright 2011 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.drools.benchmark.benchmarks;

import org.drools.benchmark.*;
import org.drools.benchmark.model.*;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;

public class FibonacciBenchmark extends AbstractBenchmark {

    private int number;
    private String drlFile;

    private KieSession ksession;

    public FibonacciBenchmark(int number) {
        this(number, "fibonacci.drl");
    }

    public FibonacciBenchmark(int number, String drlFile) {
        this.number = number;
        this.drlFile = drlFile;
    }

    @Override
    public void init(BenchmarkDefinition definition) {
        KieBase kbase = createKnowledgeBase(createKnowledgeBuilder(drlFile));
        ksession = kbase.newKieSession();
    }

    public void execute(int repNr) {
        ksession.insert(new Fibonacci(number));
        ksession.fireAllRules();
    }

    @Override
    public void terminate() {
        ksession.dispose(); // Stateful rule session must always be disposed when finished
    }
}
