/*
 * Decompiled with CFR 0.152.
 */
package org.drools.benchmark;

import java.lang.reflect.Constructor;
import org.drools.benchmark.Benchmark;

public class BenchmarkDefinition {
    private Constructor<?> constructor;
    private Object[] args;
    private String description;
    private int repetitions;
    private int warmups;
    private int threadNr;
    private boolean enabled = true;
    private boolean forceWarmup = false;
    private Benchmark benchmark;

    public BenchmarkDefinition(Constructor<?> constructor, Object[] args) {
        this.constructor = constructor;
        this.args = args;
    }

    public String getDescription() {
        return this.description;
    }

    public BenchmarkDefinition setDescription(String description) {
        this.description = description;
        return this;
    }

    public int getRepetitions() {
        return this.repetitions;
    }

    public BenchmarkDefinition setRepetitions(int repetitions) {
        this.repetitions = repetitions;
        return this;
    }

    public int getWarmups() {
        return this.warmups;
    }

    public BenchmarkDefinition setWarmups(int warmups) {
        this.warmups = warmups;
        return this;
    }

    public int getThreadNr() {
        return this.threadNr;
    }

    public BenchmarkDefinition setThreadNr(int threadNr) {
        this.threadNr = threadNr;
        return this;
    }

    public boolean isParallel() {
        return this.threadNr > 1;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public BenchmarkDefinition setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public boolean isForceWarmup() {
        return this.forceWarmup;
    }

    public BenchmarkDefinition setForceWarmup(boolean forceWarmup) {
        this.forceWarmup = forceWarmup;
        return this;
    }

    public Benchmark instance() {
        Benchmark benchmark = null;
        try {
            benchmark = (Benchmark)this.constructor.newInstance(this.args);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return benchmark;
    }

    public String toString() {
        return this.getDescription() + (this.isParallel() ? " (" + this.threadNr + " parallel threads)" : "");
    }
}

