/*
 * Decompiled with CFR 0.152.
 */
package org.drools.bpmn2;

import bitronix.tm.TransactionManagerServices;
import bitronix.tm.resource.jdbc.PoolingDataSource;
import java.io.Reader;
import java.io.StringReader;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import junit.framework.TestCase;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.bpmn2.Person;
import org.drools.bpmn2.handler.ReceiveTaskHandler;
import org.drools.bpmn2.handler.SendTaskHandler;
import org.drools.bpmn2.handler.ServiceTaskHandler;
import org.drools.bpmn2.xml.BPMNDISemanticModule;
import org.drools.bpmn2.xml.BPMNSemanticModule;
import org.drools.bpmn2.xml.XmlBPMNProcessDumper;
import org.drools.bpmn2.xpath.XPathDialectConfiguration;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderConfiguration;
import org.drools.builder.KnowledgeBuilderError;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.compiler.DialectConfiguration;
import org.drools.compiler.PackageBuilderConfiguration;
import org.drools.compiler.xml.XmlProcessReader;
import org.drools.definition.process.WorkflowProcess;
import org.drools.io.ResourceFactory;
import org.drools.persistence.jpa.JPAKnowledgeService;
import org.drools.process.instance.impl.demo.DoNothingWorkItemHandler;
import org.drools.process.instance.impl.demo.SystemOutWorkItemHandler;
import org.drools.ruleflow.core.RuleFlowProcess;
import org.drools.runtime.Environment;
import org.drools.runtime.KnowledgeRuntime;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.runtime.process.ProcessInstance;
import org.drools.runtime.process.WorkItem;
import org.drools.runtime.process.WorkItemHandler;
import org.drools.runtime.process.WorkItemManager;
import org.drools.runtime.process.WorkflowProcessInstance;
import org.drools.xml.SemanticModule;
import org.h2.tools.DeleteDbFiles;
import org.h2.tools.Server;

public class SimpleBPMNProcessTest
extends TestCase {
    private PoolingDataSource ds1;
    private EntityManagerFactory emf;
    private static Server h2Server;

    protected void setUp() {
        this.ds1 = new PoolingDataSource();
        this.ds1.setClassName("bitronix.tm.resource.jdbc.lrc.LrcXADataSource");
        this.ds1.setUniqueName("jdbc/testDS1");
        this.ds1.setMaxPoolSize(5);
        this.ds1.setAllowLocalTransactions(true);
        this.ds1.getDriverProperties().setProperty("driverClassName", "org.h2.Driver");
        this.ds1.getDriverProperties().setProperty("url", "jdbc:h2:tcp://localhost/JPADroolsFlow");
        this.ds1.getDriverProperties().setProperty("user", "sa");
        this.ds1.getDriverProperties().setProperty("password", "");
        this.ds1.init();
        this.emf = Persistence.createEntityManagerFactory((String)"org.drools.persistence.jpa");
    }

    protected void tearDown() {
        this.emf.close();
        this.ds1.close();
    }

    public void testMinimalProcess() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-MinimalProcess.xml");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ProcessInstance processInstance = ksession.startProcess("Minimal");
        SimpleBPMNProcessTest.assertTrue((processInstance.getState() == 2 ? 1 : 0) != 0);
    }

    public void testMinimalProcessWithGraphical() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-MinimalProcessWithGraphical.xml");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ProcessInstance processInstance = ksession.startProcess("Minimal");
        SimpleBPMNProcessTest.assertTrue((processInstance.getState() == 2 ? 1 : 0) != 0);
    }

    public void testMinimalProcessWithDIGraphical() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-MinimalProcessWithDIGraphical.xml");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ProcessInstance processInstance = ksession.startProcess("Minimal");
        SimpleBPMNProcessTest.assertTrue((processInstance.getState() == 2 ? 1 : 0) != 0);
    }

    public void testCompositeProcessWithDIGraphical() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-CompositeProcessWithDIGraphical.xml");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ProcessInstance processInstance = ksession.startProcess("Composite");
        SimpleBPMNProcessTest.assertTrue((processInstance.getState() == 2 ? 1 : 0) != 0);
    }

    public void testDataObject() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-DataObject.xml");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("employee", "UserId-12345");
        ProcessInstance processInstance = ksession.startProcess("Evaluation", params);
        SimpleBPMNProcessTest.assertTrue((processInstance.getState() == 2 ? 1 : 0) != 0);
    }

    public void testEvaluationProcess() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-EvaluationProcess.xml");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)new SystemOutWorkItemHandler());
        ksession.getWorkItemManager().registerWorkItemHandler("RegisterRequest", (WorkItemHandler)new SystemOutWorkItemHandler());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("employee", "UserId-12345");
        ProcessInstance processInstance = ksession.startProcess("Evaluation", params);
        SimpleBPMNProcessTest.assertTrue((processInstance.getState() == 2 ? 1 : 0) != 0);
    }

    public void testEvaluationProcess2() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-EvaluationProcess2.xml");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)new SystemOutWorkItemHandler());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("employee", "UserId-12345");
        ProcessInstance processInstance = ksession.startProcess("com.sample.evaluation", params);
        SimpleBPMNProcessTest.assertTrue((processInstance.getState() == 2 ? 1 : 0) != 0);
    }

    public void testEvaluationProcess3() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-EvaluationProcess3.xml");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)new SystemOutWorkItemHandler());
        ksession.getWorkItemManager().registerWorkItemHandler("RegisterRequest", (WorkItemHandler)new SystemOutWorkItemHandler());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("employee", "john2");
        ProcessInstance processInstance = ksession.startProcess("Evaluation", params);
        SimpleBPMNProcessTest.assertTrue((processInstance.getState() == 2 ? 1 : 0) != 0);
    }

    public void testUserTask() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-UserTask.xml");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        ProcessInstance processInstance = ksession.startProcess("UserTask");
        SimpleBPMNProcessTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        ksession = this.restoreSession(ksession);
        WorkItem workItem = workItemHandler.getWorkItem();
        SimpleBPMNProcessTest.assertNotNull((Object)workItem);
        SimpleBPMNProcessTest.assertEquals((Object)"john", (Object)workItem.getParameter("ActorId"));
        ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        this.assertProcessInstanceCompleted(processInstance.getId(), ksession);
    }

    public void testExclusiveSplit() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-ExclusiveSplit.xml");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler("Email", (WorkItemHandler)new SystemOutWorkItemHandler());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "First");
        params.put("y", "Second");
        ProcessInstance processInstance = ksession.startProcess("com.sample.test", params);
        SimpleBPMNProcessTest.assertTrue((processInstance.getState() == 2 ? 1 : 0) != 0);
    }

    public void testExclusiveSplitDefault() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-ExclusiveSplitDefault.xml");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler("Email", (WorkItemHandler)new SystemOutWorkItemHandler());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "NotFirst");
        params.put("y", "Second");
        ProcessInstance processInstance = ksession.startProcess("com.sample.test", params);
        SimpleBPMNProcessTest.assertTrue((processInstance.getState() == 2 ? 1 : 0) != 0);
    }

    public void testInclusiveSplit() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-InclusiveSplit.xml");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("x", 15);
        ProcessInstance processInstance = ksession.startProcess("com.sample.test", params);
        SimpleBPMNProcessTest.assertTrue((processInstance.getState() == 2 ? 1 : 0) != 0);
    }

    public void testInclusiveSplitDefault() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-InclusiveSplitDefault.xml");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("x", -5);
        ProcessInstance processInstance = ksession.startProcess("com.sample.test", params);
        SimpleBPMNProcessTest.assertTrue((processInstance.getState() == 2 ? 1 : 0) != 0);
    }

    public void testEventBasedSplit() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-EventBasedSplit.xml");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler("Email1", (WorkItemHandler)new SystemOutWorkItemHandler());
        ksession.getWorkItemManager().registerWorkItemHandler("Email2", (WorkItemHandler)new SystemOutWorkItemHandler());
        ProcessInstance processInstance = ksession.startProcess("com.sample.test");
        SimpleBPMNProcessTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        ksession = this.restoreSession(ksession);
        ksession.getWorkItemManager().registerWorkItemHandler("Email1", (WorkItemHandler)new SystemOutWorkItemHandler());
        ksession.getWorkItemManager().registerWorkItemHandler("Email2", (WorkItemHandler)new SystemOutWorkItemHandler());
        ksession.signalEvent("Yes", (Object)"YesValue", processInstance.getId());
        this.assertProcessInstanceCompleted(processInstance.getId(), ksession);
        processInstance = ksession.startProcess("com.sample.test");
        SimpleBPMNProcessTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        ksession = this.restoreSession(ksession);
        ksession.getWorkItemManager().registerWorkItemHandler("Email1", (WorkItemHandler)new SystemOutWorkItemHandler());
        ksession.getWorkItemManager().registerWorkItemHandler("Email2", (WorkItemHandler)new SystemOutWorkItemHandler());
        ksession.signalEvent("No", (Object)"NoValue", processInstance.getId());
        this.assertProcessInstanceCompleted(processInstance.getId(), ksession);
    }

    public void testEventBasedSplitBefore() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-EventBasedSplit.xml");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler("Email1", (WorkItemHandler)new DoNothingWorkItemHandler());
        ksession.getWorkItemManager().registerWorkItemHandler("Email2", (WorkItemHandler)new DoNothingWorkItemHandler());
        ProcessInstance processInstance = ksession.startProcess("com.sample.test");
        SimpleBPMNProcessTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        ksession = this.restoreSession(ksession);
        ksession.getWorkItemManager().registerWorkItemHandler("Email1", (WorkItemHandler)new DoNothingWorkItemHandler());
        ksession.getWorkItemManager().registerWorkItemHandler("Email2", (WorkItemHandler)new DoNothingWorkItemHandler());
        ksession.signalEvent("Yes", (Object)"YesValue", processInstance.getId());
        SimpleBPMNProcessTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        processInstance = ksession.startProcess("com.sample.test");
        SimpleBPMNProcessTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        ksession = this.restoreSession(ksession);
        ksession.getWorkItemManager().registerWorkItemHandler("Email1", (WorkItemHandler)new DoNothingWorkItemHandler());
        ksession.getWorkItemManager().registerWorkItemHandler("Email2", (WorkItemHandler)new DoNothingWorkItemHandler());
        ksession.signalEvent("No", (Object)"NoValue", processInstance.getId());
        SimpleBPMNProcessTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
    }

    public void testEventBasedSplitAfter() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-EventBasedSplit.xml");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler("Email1", (WorkItemHandler)new SystemOutWorkItemHandler());
        ksession.getWorkItemManager().registerWorkItemHandler("Email2", (WorkItemHandler)new DoNothingWorkItemHandler());
        ProcessInstance processInstance = ksession.startProcess("com.sample.test");
        SimpleBPMNProcessTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        ksession = this.restoreSession(ksession);
        ksession.getWorkItemManager().registerWorkItemHandler("Email1", (WorkItemHandler)new SystemOutWorkItemHandler());
        ksession.getWorkItemManager().registerWorkItemHandler("Email2", (WorkItemHandler)new DoNothingWorkItemHandler());
        ksession.signalEvent("Yes", (Object)"YesValue", processInstance.getId());
        SimpleBPMNProcessTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        ksession = this.restoreSession(ksession);
        ksession.getWorkItemManager().registerWorkItemHandler("Email1", (WorkItemHandler)new SystemOutWorkItemHandler());
        ksession.getWorkItemManager().registerWorkItemHandler("Email2", (WorkItemHandler)new DoNothingWorkItemHandler());
        ksession.signalEvent("No", (Object)"NoValue", processInstance.getId());
    }

    public void testEventBasedSplit2() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-EventBasedSplit2.xml");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler("Email1", (WorkItemHandler)new SystemOutWorkItemHandler());
        ksession.getWorkItemManager().registerWorkItemHandler("Email2", (WorkItemHandler)new SystemOutWorkItemHandler());
        ProcessInstance processInstance = ksession.startProcess("com.sample.test");
        SimpleBPMNProcessTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        ksession = this.restoreSession(ksession);
        ksession.getWorkItemManager().registerWorkItemHandler("Email1", (WorkItemHandler)new SystemOutWorkItemHandler());
        ksession.getWorkItemManager().registerWorkItemHandler("Email2", (WorkItemHandler)new SystemOutWorkItemHandler());
        ksession.signalEvent("Yes", (Object)"YesValue", processInstance.getId());
        this.assertProcessInstanceCompleted(processInstance.getId(), ksession);
        Thread.sleep(800L);
        ksession = this.restoreSession(ksession);
        ksession.getWorkItemManager().registerWorkItemHandler("Email1", (WorkItemHandler)new SystemOutWorkItemHandler());
        ksession.getWorkItemManager().registerWorkItemHandler("Email2", (WorkItemHandler)new SystemOutWorkItemHandler());
        ksession.fireAllRules();
        ksession = this.restoreSession(ksession);
        ksession.getWorkItemManager().registerWorkItemHandler("Email1", (WorkItemHandler)new SystemOutWorkItemHandler());
        ksession.getWorkItemManager().registerWorkItemHandler("Email2", (WorkItemHandler)new SystemOutWorkItemHandler());
        processInstance = ksession.startProcess("com.sample.test");
        SimpleBPMNProcessTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        Thread.sleep(800L);
        ksession = this.restoreSession(ksession);
        ksession.getWorkItemManager().registerWorkItemHandler("Email1", (WorkItemHandler)new SystemOutWorkItemHandler());
        ksession.getWorkItemManager().registerWorkItemHandler("Email2", (WorkItemHandler)new SystemOutWorkItemHandler());
        ksession.fireAllRules();
        this.assertProcessInstanceCompleted(processInstance.getId(), ksession);
    }

    public void testEventBasedSplit3() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-EventBasedSplit3.xml");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler("Email1", (WorkItemHandler)new SystemOutWorkItemHandler());
        ksession.getWorkItemManager().registerWorkItemHandler("Email2", (WorkItemHandler)new SystemOutWorkItemHandler());
        Person jack = new Person();
        jack.setName("Jack");
        ProcessInstance processInstance = ksession.startProcess("com.sample.test");
        SimpleBPMNProcessTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        ksession = this.restoreSession(ksession);
        ksession.getWorkItemManager().registerWorkItemHandler("Email1", (WorkItemHandler)new SystemOutWorkItemHandler());
        ksession.getWorkItemManager().registerWorkItemHandler("Email2", (WorkItemHandler)new SystemOutWorkItemHandler());
        ksession.signalEvent("Yes", (Object)"YesValue", processInstance.getId());
        this.assertProcessInstanceCompleted(processInstance.getId(), ksession);
        processInstance = ksession.startProcess("com.sample.test");
        SimpleBPMNProcessTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        ksession = this.restoreSession(ksession);
        ksession.getWorkItemManager().registerWorkItemHandler("Email1", (WorkItemHandler)new SystemOutWorkItemHandler());
        ksession.getWorkItemManager().registerWorkItemHandler("Email2", (WorkItemHandler)new SystemOutWorkItemHandler());
        ksession.insert((Object)jack);
        this.assertProcessInstanceCompleted(processInstance.getId(), ksession);
    }

    public void testEventBasedSplit4() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-EventBasedSplit4.xml");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler("Email1", (WorkItemHandler)new SystemOutWorkItemHandler());
        ksession.getWorkItemManager().registerWorkItemHandler("Email2", (WorkItemHandler)new SystemOutWorkItemHandler());
        ProcessInstance processInstance = ksession.startProcess("com.sample.test");
        SimpleBPMNProcessTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        ksession = this.restoreSession(ksession);
        ksession.getWorkItemManager().registerWorkItemHandler("Email1", (WorkItemHandler)new SystemOutWorkItemHandler());
        ksession.getWorkItemManager().registerWorkItemHandler("Email2", (WorkItemHandler)new SystemOutWorkItemHandler());
        ksession.signalEvent("Message-YesMessage", (Object)"YesValue", processInstance.getId());
        this.assertProcessInstanceCompleted(processInstance.getId(), ksession);
        ksession = this.restoreSession(ksession);
        ksession.getWorkItemManager().registerWorkItemHandler("Email1", (WorkItemHandler)new SystemOutWorkItemHandler());
        ksession.getWorkItemManager().registerWorkItemHandler("Email2", (WorkItemHandler)new SystemOutWorkItemHandler());
        processInstance = ksession.startProcess("com.sample.test");
        ksession.signalEvent("Message-NoMessage", (Object)"NoValue", processInstance.getId());
        this.assertProcessInstanceCompleted(processInstance.getId(), ksession);
    }

    public void testEventBasedSplit5() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-EventBasedSplit5.xml");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler("Email1", (WorkItemHandler)new SystemOutWorkItemHandler());
        ksession.getWorkItemManager().registerWorkItemHandler("Email2", (WorkItemHandler)new SystemOutWorkItemHandler());
        ReceiveTaskHandler receiveTaskHandler = new ReceiveTaskHandler((KnowledgeRuntime)ksession);
        ksession.getWorkItemManager().registerWorkItemHandler("Receive Task", (WorkItemHandler)receiveTaskHandler);
        ProcessInstance processInstance = ksession.startProcess("com.sample.test");
        SimpleBPMNProcessTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        ksession = this.restoreSession(ksession);
        ksession.getWorkItemManager().registerWorkItemHandler("Email1", (WorkItemHandler)new SystemOutWorkItemHandler());
        ksession.getWorkItemManager().registerWorkItemHandler("Email2", (WorkItemHandler)new SystemOutWorkItemHandler());
        receiveTaskHandler.setKnowledgeRuntime((KnowledgeRuntime)ksession);
        ksession.getWorkItemManager().registerWorkItemHandler("Receive Task", (WorkItemHandler)receiveTaskHandler);
        receiveTaskHandler.messageReceived("YesMessage", (Object)"YesValue");
        this.assertProcessInstanceCompleted(processInstance.getId(), ksession);
        receiveTaskHandler.messageReceived("NoMessage", (Object)"NoValue");
        ksession = this.restoreSession(ksession);
        ksession.getWorkItemManager().registerWorkItemHandler("Email1", (WorkItemHandler)new SystemOutWorkItemHandler());
        ksession.getWorkItemManager().registerWorkItemHandler("Email2", (WorkItemHandler)new SystemOutWorkItemHandler());
        receiveTaskHandler.setKnowledgeRuntime((KnowledgeRuntime)ksession);
        ksession.getWorkItemManager().registerWorkItemHandler("Receive Task", (WorkItemHandler)receiveTaskHandler);
        processInstance = ksession.startProcess("com.sample.test");
        receiveTaskHandler.messageReceived("NoMessage", (Object)"NoValue");
        this.assertProcessInstanceCompleted(processInstance.getId(), ksession);
        receiveTaskHandler.messageReceived("YesMessage", (Object)"YesValue");
    }

    public void testCallActivity() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"BPMN2-CallActivity.xml"), ResourceType.BPMN2);
        kbuilder.add(ResourceFactory.newClassPathResource((String)"BPMN2-CallActivitySubProcess.xml"), ResourceType.BPMN2);
        if (!kbuilder.getErrors().isEmpty()) {
            for (KnowledgeBuilderError error : kbuilder.getErrors()) {
                System.err.println(error);
            }
            throw new IllegalArgumentException("Errors while parsing knowledge base");
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "oldValue");
        ProcessInstance processInstance = ksession.startProcess("ParentProcess", params);
        SimpleBPMNProcessTest.assertTrue((processInstance.getState() == 2 ? 1 : 0) != 0);
        SimpleBPMNProcessTest.assertEquals((Object)"new value", (Object)((WorkflowProcessInstance)processInstance).getVariable("y"));
    }

    public void testSubProcess() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-SubProcess.xml");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ProcessInstance processInstance = ksession.startProcess("SubProcess");
        SimpleBPMNProcessTest.assertTrue((processInstance.getState() == 2 ? 1 : 0) != 0);
    }

    public void testMultiInstanceLoopCharacteristicsProcess() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-MultiInstanceLoopCharacteristicsProcess.xml");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        HashMap params = new HashMap();
        ArrayList<String> myList = new ArrayList<String>();
        myList.add("First Item");
        myList.add("Second Item");
        params.put("list", myList);
        ProcessInstance processInstance = ksession.startProcess("MultiInstanceLoopCharacteristicsProcess", params);
        SimpleBPMNProcessTest.assertTrue((processInstance.getState() == 2 ? 1 : 0) != 0);
    }

    public void testEscalationBoundaryEvent() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-EscalationBoundaryEvent.xml");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ProcessInstance processInstance = ksession.startProcess("EscalationBoundaryEvent");
        SimpleBPMNProcessTest.assertTrue((processInstance.getState() == 2 ? 1 : 0) != 0);
    }

    public void testEscalationBoundaryEventInterrupting() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-EscalationBoundaryEventInterrupting.xml");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler("MyTask", (WorkItemHandler)new DoNothingWorkItemHandler());
        ProcessInstance processInstance = ksession.startProcess("EscalationBoundaryEvent");
        SimpleBPMNProcessTest.assertTrue((processInstance.getState() == 2 ? 1 : 0) != 0);
    }

    public void testErrorBoundaryEvent() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-ErrorBoundaryEventInterrupting.xml");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler("MyTask", (WorkItemHandler)new DoNothingWorkItemHandler());
        ProcessInstance processInstance = ksession.startProcess("ErrorBoundaryEvent");
        this.assertProcessInstanceCompleted(processInstance.getId(), ksession);
    }

    public void testTimerBoundaryEvent() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-TimerBoundaryEvent.xml");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler("MyTask", (WorkItemHandler)new DoNothingWorkItemHandler());
        ProcessInstance processInstance = ksession.startProcess("TimerBoundaryEvent");
        SimpleBPMNProcessTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        Thread.sleep(1000L);
        ksession = this.restoreSession(ksession);
        System.out.println("Firing timer");
        ksession.fireAllRules();
        this.assertProcessInstanceCompleted(processInstance.getId(), ksession);
    }

    public void testTimerBoundaryEventInterrupting() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-TimerBoundaryEventInterrupting.xml");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler("MyTask", (WorkItemHandler)new DoNothingWorkItemHandler());
        ProcessInstance processInstance = ksession.startProcess("TimerBoundaryEvent");
        SimpleBPMNProcessTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        Thread.sleep(1000L);
        ksession = this.restoreSession(ksession);
        System.out.println("Firing timer");
        ksession.fireAllRules();
        this.assertProcessInstanceCompleted(processInstance.getId(), ksession);
    }

    public void testAdHocSubProcess() throws Exception {
        KnowledgeBuilderConfiguration conf = KnowledgeBuilderFactory.newKnowledgeBuilderConfiguration();
        ((PackageBuilderConfiguration)conf).initSemanticModules();
        ((PackageBuilderConfiguration)conf).addSemanticModule((SemanticModule)new BPMNSemanticModule());
        ((PackageBuilderConfiguration)conf).addSemanticModule((SemanticModule)new BPMNDISemanticModule());
        ((PackageBuilderConfiguration)conf).addDialect("XPath", (DialectConfiguration)new XPathDialectConfiguration());
        XmlProcessReader processReader = new XmlProcessReader(((PackageBuilderConfiguration)conf).getSemanticModules());
        RuleFlowProcess p = (RuleFlowProcess)processReader.read(SimpleBPMNProcessTest.class.getResourceAsStream("/BPMN2-AdHocSubProcess.xml"));
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder((KnowledgeBuilderConfiguration)conf);
        kbuilder.add(ResourceFactory.newReaderResource((Reader)new StringReader(XmlBPMNProcessDumper.INSTANCE.dump((WorkflowProcess)p))), ResourceType.BPMN2);
        kbuilder.add(ResourceFactory.newClassPathResource((String)"BPMN2-AdHocSubProcess.drl"), ResourceType.DRL);
        if (!kbuilder.getErrors().isEmpty()) {
            for (KnowledgeBuilderError error : kbuilder.getErrors()) {
                System.err.println(error);
            }
            throw new IllegalArgumentException("Errors while parsing knowledge base");
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        ProcessInstance processInstance = ksession.startProcess("AdHocSubProcess");
        SimpleBPMNProcessTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        WorkItem workItem = workItemHandler.getWorkItem();
        SimpleBPMNProcessTest.assertNull((Object)workItem);
        ksession = this.restoreSession(ksession);
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        ksession.fireAllRules();
        System.out.println("Signaling Hello2");
        ksession.signalEvent("Hello2", null, processInstance.getId());
        workItem = workItemHandler.getWorkItem();
        SimpleBPMNProcessTest.assertNotNull((Object)workItem);
        ksession = this.restoreSession(ksession);
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
    }

    public void testAdHocSubProcessAutoComplete() throws Exception {
        KnowledgeBuilderConfiguration conf = KnowledgeBuilderFactory.newKnowledgeBuilderConfiguration();
        ((PackageBuilderConfiguration)conf).initSemanticModules();
        ((PackageBuilderConfiguration)conf).addSemanticModule((SemanticModule)new BPMNSemanticModule());
        ((PackageBuilderConfiguration)conf).addSemanticModule((SemanticModule)new BPMNDISemanticModule());
        ((PackageBuilderConfiguration)conf).addDialect("XPath", (DialectConfiguration)new XPathDialectConfiguration());
        XmlProcessReader processReader = new XmlProcessReader(((PackageBuilderConfiguration)conf).getSemanticModules());
        RuleFlowProcess p = (RuleFlowProcess)processReader.read(SimpleBPMNProcessTest.class.getResourceAsStream("/BPMN2-AdHocSubProcessAutoComplete.xml"));
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder((KnowledgeBuilderConfiguration)conf);
        kbuilder.add(ResourceFactory.newReaderResource((Reader)new StringReader(XmlBPMNProcessDumper.INSTANCE.dump((WorkflowProcess)p))), ResourceType.BPMN2);
        kbuilder.add(ResourceFactory.newClassPathResource((String)"BPMN2-AdHocSubProcess.drl"), ResourceType.DRL);
        if (!kbuilder.getErrors().isEmpty()) {
            for (KnowledgeBuilderError error : kbuilder.getErrors()) {
                System.err.println(error);
            }
            throw new IllegalArgumentException("Errors while parsing knowledge base");
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        ProcessInstance processInstance = ksession.startProcess("AdHocSubProcess");
        SimpleBPMNProcessTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        WorkItem workItem = workItemHandler.getWorkItem();
        SimpleBPMNProcessTest.assertNull((Object)workItem);
        ksession = this.restoreSession(ksession);
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        ksession.fireAllRules();
        workItem = workItemHandler.getWorkItem();
        SimpleBPMNProcessTest.assertNotNull((Object)workItem);
        ksession = this.restoreSession(ksession);
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        this.assertProcessInstanceCompleted(processInstance.getId(), ksession);
    }

    public void testIntermediateCatchEventSignal() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-IntermediateCatchEventSignal.xml");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)new DoNothingWorkItemHandler());
        ProcessInstance processInstance = ksession.startProcess("IntermediateCatchEvent");
        SimpleBPMNProcessTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        ksession = this.restoreSession(ksession);
        ksession.signalEvent("MyMessage", (Object)"SomeValue", processInstance.getId());
        this.assertProcessInstanceCompleted(processInstance.getId(), ksession);
    }

    public void testIntermediateCatchEventMessage() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-IntermediateCatchEventMessage.xml");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)new DoNothingWorkItemHandler());
        ProcessInstance processInstance = ksession.startProcess("IntermediateCatchEvent");
        SimpleBPMNProcessTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        ksession = this.restoreSession(ksession);
        ksession.signalEvent("Message-HelloMessage", (Object)"SomeValue", processInstance.getId());
        this.assertProcessInstanceCompleted(processInstance.getId(), ksession);
    }

    public void testIntermediateCatchEventTimer() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-IntermediateCatchEventTimer.xml");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)new DoNothingWorkItemHandler());
        ProcessInstance processInstance = ksession.startProcess("IntermediateCatchEvent");
        SimpleBPMNProcessTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        Thread.sleep(1000L);
        ksession = this.restoreSession(ksession);
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)new DoNothingWorkItemHandler());
        ksession.fireAllRules();
        this.assertProcessInstanceCompleted(processInstance.getId(), ksession);
    }

    public void testIntermediateCatchEventCondition() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-IntermediateCatchEventCondition.xml");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ProcessInstance processInstance = ksession.startProcess("IntermediateCatchEvent");
        SimpleBPMNProcessTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        ksession = this.restoreSession(ksession);
        Person person = new Person();
        person.setName("Jack");
        ksession.insert((Object)person);
        this.assertProcessInstanceCompleted(processInstance.getId(), ksession);
    }

    public void testErrorEndEventProcess() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-ErrorEndEvent.xml");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ProcessInstance processInstance = ksession.startProcess("ErrorEndEvent");
        this.assertProcessInstanceAborted(processInstance.getId(), ksession);
    }

    public void testEscalationEndEventProcess() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-EscalationEndEvent.xml");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ProcessInstance processInstance = ksession.startProcess("EscalationEndEvent");
        this.assertProcessInstanceAborted(processInstance.getId(), ksession);
    }

    public void testEscalationIntermediateThrowEventProcess() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-IntermediateThrowEventEscalation.xml");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ProcessInstance processInstance = ksession.startProcess("EscalationIntermediateThrowEvent");
        this.assertProcessInstanceAborted(processInstance.getId(), ksession);
    }

    public void testCompensateIntermediateThrowEventProcess() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-IntermediateThrowEventCompensate.xml");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ProcessInstance processInstance = ksession.startProcess("CompensateIntermediateThrowEvent");
        this.assertProcessInstanceCompleted(processInstance.getId(), ksession);
    }

    public void testCompensateEndEventProcess() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-CompensateEndEvent.xml");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ProcessInstance processInstance = ksession.startProcess("CompensateEndEvent");
        this.assertProcessInstanceCompleted(processInstance.getId(), ksession);
    }

    public void testServiceTask() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-ServiceProcess.xml");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler("Service Task", (WorkItemHandler)new ServiceTaskHandler());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("s", "john");
        WorkflowProcessInstance processInstance = (WorkflowProcessInstance)ksession.startProcess("ServiceProcess", params);
        this.assertProcessInstanceCompleted(processInstance.getId(), ksession);
        SimpleBPMNProcessTest.assertEquals((Object)"Hello john!", (Object)processInstance.getVariable("s"));
    }

    public void testSendTask() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-SendTask.xml");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler("Send Task", (WorkItemHandler)new SendTaskHandler());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("s", "john");
        WorkflowProcessInstance processInstance = (WorkflowProcessInstance)ksession.startProcess("SendTask", params);
        this.assertProcessInstanceCompleted(processInstance.getId(), ksession);
    }

    public void testReceiveTask() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-ReceiveTask.xml");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ReceiveTaskHandler receiveTaskHandler = new ReceiveTaskHandler((KnowledgeRuntime)ksession);
        ksession.getWorkItemManager().registerWorkItemHandler("Receive Task", (WorkItemHandler)receiveTaskHandler);
        WorkflowProcessInstance processInstance = (WorkflowProcessInstance)ksession.startProcess("ReceiveTask");
        SimpleBPMNProcessTest.assertEquals((int)1, (int)processInstance.getState());
        ksession = this.restoreSession(ksession);
        receiveTaskHandler.messageReceived("HelloMessage", (Object)"Hello john!");
        this.assertProcessInstanceCompleted(processInstance.getId(), ksession);
    }

    public void testConditionalStart() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-ConditionalStart.xml");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        Person person = new Person();
        person.setName("jack");
        ksession.insert((Object)person);
        ksession.fireAllRules();
        person = new Person();
        person.setName("john");
        ksession.insert((Object)person);
        ksession.fireAllRules();
    }

    public void testTimerStart() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-TimerStart.xml");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        Thread.sleep(600L);
        for (int i = 0; i < 5; ++i) {
            Thread.sleep(500L);
        }
    }

    public void testSignalStart() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-SignalStart.xml");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.signalEvent("MyStartSignal", (Object)"NewValue");
    }

    public void testSignalEnd() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-SignalEndEvent.xml");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "MyValue");
        ksession.startProcess("SignalEndEvent", params);
    }

    public void testMessageStart() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-MessageStart.xml");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.signalEvent("Message-HelloMessage", (Object)"NewValue");
    }

    public void testMessageEnd() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-MessageEndEvent.xml");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler("Send Task", (WorkItemHandler)new SendTaskHandler());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "MyValue");
        ProcessInstance processInstance = ksession.startProcess("MessageEndEvent", params);
        SimpleBPMNProcessTest.assertEquals((int)2, (int)processInstance.getState());
    }

    public void testMessageIntermediateThrow() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-IntermediateThrowEventMessage.xml");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler("Send Task", (WorkItemHandler)new SendTaskHandler());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "MyValue");
        ProcessInstance processInstance = ksession.startProcess("MessageIntermediateEvent", params);
        SimpleBPMNProcessTest.assertEquals((int)2, (int)processInstance.getState());
    }

    public void testSignalIntermediateThrow() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-IntermediateThrowEventSignal.xml");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "MyValue");
        ProcessInstance processInstance = ksession.startProcess("SignalIntermediateEvent", params);
        SimpleBPMNProcessTest.assertEquals((int)2, (int)processInstance.getState());
    }

    public void testNoneIntermediateThrow() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-IntermediateThrowEventNone.xml");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ProcessInstance processInstance = ksession.startProcess("NoneIntermediateEvent", null);
        SimpleBPMNProcessTest.assertEquals((int)2, (int)processInstance.getState());
    }

    private KnowledgeBase createKnowledgeBase(String process) throws Exception {
        KnowledgeBuilderConfiguration conf = KnowledgeBuilderFactory.newKnowledgeBuilderConfiguration();
        ((PackageBuilderConfiguration)conf).initSemanticModules();
        ((PackageBuilderConfiguration)conf).addSemanticModule((SemanticModule)new BPMNSemanticModule());
        ((PackageBuilderConfiguration)conf).addSemanticModule((SemanticModule)new BPMNDISemanticModule());
        ((PackageBuilderConfiguration)conf).addDialect("XPath", (DialectConfiguration)new XPathDialectConfiguration());
        XmlProcessReader processReader = new XmlProcessReader(((PackageBuilderConfiguration)conf).getSemanticModules());
        RuleFlowProcess p = (RuleFlowProcess)processReader.read(SimpleBPMNProcessTest.class.getResourceAsStream("/" + process));
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder((KnowledgeBuilderConfiguration)conf);
        kbuilder.add(ResourceFactory.newReaderResource((Reader)new StringReader(XmlBPMNProcessDumper.INSTANCE.dump((WorkflowProcess)p))), ResourceType.BPMN2);
        if (!kbuilder.getErrors().isEmpty()) {
            for (KnowledgeBuilderError error : kbuilder.getErrors()) {
                System.err.println(error);
            }
            throw new IllegalArgumentException("Errors while parsing knowledge base");
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        return kbase;
    }

    private StatefulKnowledgeSession createKnowledgeSession(KnowledgeBase kbase) {
        Environment env = KnowledgeBaseFactory.newEnvironment();
        env.set("drools.persistence.jpa.EntityManagerFactory", (Object)this.emf);
        env.set("drools.transaction.TransactionManager", (Object)TransactionManagerServices.getTransactionManager());
        return JPAKnowledgeService.newStatefulKnowledgeSession((KnowledgeBase)kbase, null, (Environment)env);
    }

    private StatefulKnowledgeSession restoreSession(StatefulKnowledgeSession ksession) {
        int id = ksession.getId();
        KnowledgeBase kbase = ksession.getKnowledgeBase();
        Environment env = ksession.getEnvironment();
        return JPAKnowledgeService.loadStatefulKnowledgeSession((int)id, (KnowledgeBase)kbase, null, (Environment)env);
    }

    private void assertProcessInstanceCompleted(long processInstanceId, StatefulKnowledgeSession ksession) {
        SimpleBPMNProcessTest.assertNull((Object)ksession.getProcessInstance(processInstanceId));
    }

    private void assertProcessInstanceAborted(long processInstanceId, StatefulKnowledgeSession ksession) {
        SimpleBPMNProcessTest.assertNull((Object)ksession.getProcessInstance(processInstanceId));
    }

    static {
        try {
            DeleteDbFiles.execute((String)"", (String)"JPADroolsFlow", (boolean)true);
            h2Server = Server.createTcpServer((String[])new String[0]);
            h2Server.start();
        }
        catch (SQLException e) {
            throw new RuntimeException("can't start h2 server db", e);
        }
    }

    private static class TestWorkItemHandler
    implements WorkItemHandler {
        private WorkItem workItem;

        private TestWorkItemHandler() {
        }

        public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
            this.workItem = workItem;
        }

        public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
        }

        public WorkItem getWorkItem() {
            WorkItem result = this.workItem;
            this.workItem = null;
            return result;
        }
    }
}

