/*
 * Decompiled with CFR 0.152.
 */
package org.drools.bpmn2.legacy.beta1;

import java.util.HashSet;
import org.drools.bpmn2.core.Lane;
import org.drools.bpmn2.core.SequenceFlow;
import org.drools.bpmn2.legacy.beta1.XmlBPMNProcessDumper;
import org.drools.compiler.xml.XmlDumper;
import org.drools.process.core.context.variable.Variable;
import org.drools.workflow.core.Node;
import org.drools.workflow.core.NodeContainer;
import org.drools.xml.BaseAbstractHandler;
import org.drools.xml.ExtensibleXmlParser;
import org.drools.xml.Handler;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class AbstractNodeHandler
extends BaseAbstractHandler
implements Handler {
    protected static final String EOL = System.getProperty("line.separator");

    public AbstractNodeHandler() {
        this.initValidParents();
        this.initValidPeers();
        this.allowNesting = true;
    }

    protected void initValidParents() {
        this.validParents = new HashSet();
        this.validParents.add(NodeContainer.class);
    }

    protected void initValidPeers() {
        this.validPeers = new HashSet();
        this.validPeers.add(null);
        this.validPeers.add(Lane.class);
        this.validPeers.add(Variable.class);
        this.validPeers.add(Node.class);
        this.validPeers.add(SequenceFlow.class);
    }

    public Object start(String uri, String localName, Attributes attrs, ExtensibleXmlParser parser) throws SAXException {
        parser.startElementBuilder(localName, attrs);
        Node node = this.createNode(attrs);
        String id = attrs.getValue("id");
        try {
            id = id.substring(1);
            id = id.substring(id.lastIndexOf("-") + 1);
            String name = attrs.getValue("name");
            node.setName(name);
            node.setId((long)new Integer(id).intValue());
        }
        catch (NumberFormatException e) {
            long newId = 0L;
            NodeContainer nodeContainer = (NodeContainer)parser.getParent();
            for (org.drools.definition.process.Node n : nodeContainer.getNodes()) {
                if (n.getId() <= newId) continue;
                newId = n.getId();
            }
            node.setId(++newId);
            node.setMetaData("UniqueId", (Object)attrs.getValue("id"));
        }
        return node;
    }

    protected abstract Node createNode(Attributes var1);

    public Object end(String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        Element element = parser.endElementBuilder();
        Node node = (Node)parser.getCurrent();
        this.handleNode(node, element, uri, localName, parser);
        NodeContainer nodeContainer = (NodeContainer)parser.getParent();
        nodeContainer.addNode((org.drools.definition.process.Node)node);
        return node;
    }

    protected void handleNode(Node node, Element element, String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        String height;
        String width;
        String y;
        String x = element.getAttribute("x");
        if (x != null && x.length() != 0) {
            try {
                node.setMetaData("x", (Object)new Integer(x));
            }
            catch (NumberFormatException exc) {
                throw new SAXParseException("<" + localName + "> requires an Integer 'x' attribute", parser.getLocator());
            }
        }
        if ((y = element.getAttribute("y")) != null && y.length() != 0) {
            try {
                node.setMetaData("y", (Object)new Integer(y));
            }
            catch (NumberFormatException exc) {
                throw new SAXParseException("<" + localName + "> requires an Integer 'y' attribute", parser.getLocator());
            }
        }
        if ((width = element.getAttribute("width")) != null && width.length() != 0) {
            try {
                node.setMetaData("width", (Object)new Integer(width));
            }
            catch (NumberFormatException exc) {
                throw new SAXParseException("<" + localName + "> requires an Integer 'width' attribute", parser.getLocator());
            }
        }
        if ((height = element.getAttribute("height")) != null && height.length() != 0) {
            try {
                node.setMetaData("height", (Object)new Integer(height));
            }
            catch (NumberFormatException exc) {
                throw new SAXParseException("<" + localName + "> requires an Integer 'height' attribute", parser.getLocator());
            }
        }
    }

    public abstract void writeNode(Node var1, StringBuilder var2, boolean var3);

    protected void writeNode(String name, Node node, StringBuilder xmlDump, boolean includeMeta) {
        xmlDump.append("    <" + name + " ");
        xmlDump.append("id=\"" + XmlBPMNProcessDumper.getUniqueNodeId((org.drools.definition.process.Node)node) + "\" ");
        if (node.getName() != null) {
            xmlDump.append("name=\"" + XmlDumper.replaceIllegalChars((String)node.getName()) + "\" ");
        }
    }

    protected void endNode(StringBuilder xmlDump) {
        xmlDump.append("/>" + EOL);
    }

    protected void endNode(String name, StringBuilder xmlDump) {
        xmlDump.append("    </" + name + ">" + EOL);
    }
}

