/*
 * Decompiled with CFR 0.152.
 */
package org.drools.bpmn2.legacy.beta1;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.drools.bpmn2.core.SequenceFlow;
import org.drools.process.core.context.variable.Variable;
import org.drools.ruleflow.core.RuleFlowProcess;
import org.drools.workflow.core.Node;
import org.drools.workflow.core.NodeContainer;
import org.drools.workflow.core.node.CompositeNode;
import org.drools.xml.BaseAbstractHandler;
import org.drools.xml.ExtensibleXmlParser;
import org.drools.xml.Handler;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SequenceFlowHandler
extends BaseAbstractHandler
implements Handler {
    public SequenceFlowHandler() {
        this.initValidParents();
        this.initValidPeers();
        this.allowNesting = false;
    }

    protected void initValidParents() {
        this.validParents = new HashSet();
        this.validParents.add(NodeContainer.class);
    }

    protected void initValidPeers() {
        this.validPeers = new HashSet();
        this.validPeers.add(null);
        this.validPeers.add(Variable.class);
        this.validPeers.add(Node.class);
        this.validPeers.add(SequenceFlow.class);
    }

    public Object start(String uri, String localName, Attributes attrs, ExtensibleXmlParser parser) throws SAXException {
        parser.startElementBuilder(localName, attrs);
        String id = attrs.getValue("id");
        String sourceRef = attrs.getValue("sourceRef");
        String targetRef = attrs.getValue("targetRef");
        String bendpoints = attrs.getValue("g:bendpoints");
        String name = attrs.getValue("name");
        NodeContainer nodeContainer = (NodeContainer)parser.getParent();
        ArrayList<SequenceFlow> connections = null;
        if (nodeContainer instanceof RuleFlowProcess) {
            connections = (ArrayList<SequenceFlow>)((RuleFlowProcess)nodeContainer).getMetaData("BPMN.Connections");
            if (connections == null) {
                connections = new ArrayList<SequenceFlow>();
                ((RuleFlowProcess)nodeContainer).setMetaData("BPMN.Connections", connections);
            }
        } else if (nodeContainer instanceof CompositeNode && (connections = (List)((CompositeNode)nodeContainer).getMetaData("BPMN.Connections")) == null) {
            connections = new ArrayList();
            ((CompositeNode)nodeContainer).setMetaData("BPMN.Connections", connections);
        }
        SequenceFlow connection = new SequenceFlow(id, sourceRef, targetRef);
        connection.setBendpoints(bendpoints);
        connection.setName(name);
        connections.add(connection);
        return connection;
    }

    public Object end(String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        Element element = parser.endElementBuilder();
        SequenceFlow sequenceFlow = (SequenceFlow)parser.getCurrent();
        for (org.w3c.dom.Node xmlNode = element.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            String nodeName = xmlNode.getNodeName();
            if (!"conditionExpression".equals(nodeName)) continue;
            String expression = xmlNode.getTextContent();
            org.w3c.dom.Node languageNode = xmlNode.getAttributes().getNamedItem("language");
            if (languageNode != null) {
                String language = languageNode.getNodeValue();
                if ("http://www.java.com/java".equals(language)) {
                    sequenceFlow.setLanguage("java");
                } else if ("http://www.jboss.org/drools/rule".equals(language)) {
                    sequenceFlow.setType("rule");
                } else if ("http://www.w3.org/1999/XPath".equals(language)) {
                    sequenceFlow.setLanguage("XPath");
                } else {
                    throw new IllegalArgumentException("Unknown language " + language);
                }
            }
            sequenceFlow.setExpression(expression);
        }
        return sequenceFlow;
    }

    public Class<?> generateNodeFor() {
        return SequenceFlow.class;
    }
}

