/*
 * Decompiled with CFR 0.152.
 */
package org.drools.bpmn2.legacy.beta1;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.drools.bpmn2.legacy.beta1.TaskHandler;
import org.drools.bpmn2.legacy.beta1.XmlBPMNProcessDumper;
import org.drools.process.core.Work;
import org.drools.process.core.impl.WorkImpl;
import org.drools.workflow.core.Node;
import org.drools.workflow.core.node.HumanTaskNode;
import org.drools.workflow.core.node.WorkItemNode;
import org.drools.xml.ExtensibleXmlParser;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class UserTaskHandler
extends TaskHandler {
    protected Node createNode(Attributes attrs) {
        return new HumanTaskNode();
    }

    public Class generateNodeFor() {
        return HumanTaskNode.class;
    }

    protected void handleNode(Node node, Element element, String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        super.handleNode(node, element, uri, localName, parser);
        HumanTaskNode humanTaskNode = (HumanTaskNode)node;
        WorkImpl work = new WorkImpl();
        work.setName("Human Task");
        humanTaskNode.setWork((Work)work);
        HashMap<String, String> dataInputs = new HashMap<String, String>();
        HashMap<String, String> dataOutputs = new HashMap<String, String>();
        ArrayList<String> owners = new ArrayList<String>();
        for (org.w3c.dom.Node xmlNode = element.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            String nodeName = xmlNode.getNodeName();
            if ("ioSpecification".equals(nodeName)) {
                this.readIoSpecification(xmlNode, dataInputs, dataOutputs);
                continue;
            }
            if ("dataInputAssociation".equals(nodeName)) {
                this.readDataInputAssociation(xmlNode, (WorkItemNode)humanTaskNode, dataInputs);
                continue;
            }
            if ("dataOutputAssociation".equals(nodeName)) {
                this.readDataOutputAssociation(xmlNode, (WorkItemNode)humanTaskNode, dataOutputs);
                continue;
            }
            if (!"potentialOwner".equals(nodeName)) continue;
            owners.add(this.readPotentialOwner(xmlNode, humanTaskNode));
        }
        if (owners.size() > 0) {
            String owner = (String)owners.get(0);
            for (int i = 1; i < owners.size(); ++i) {
                owner = owner + "," + (String)owners.get(i);
            }
            humanTaskNode.getWork().setParameter("ActorId", (Object)owner);
        }
    }

    protected String readPotentialOwner(org.w3c.dom.Node xmlNode, HumanTaskNode humanTaskNode) {
        return xmlNode.getFirstChild().getFirstChild().getFirstChild().getTextContent();
    }

    public void writeNode(Node node, StringBuilder xmlDump, boolean includeMeta) {
        HumanTaskNode humanTaskNode = (HumanTaskNode)node;
        this.writeNode("userTask", (Node)humanTaskNode, xmlDump, includeMeta);
        xmlDump.append("implementation=\"humanTaskWebService\" >" + EOL);
        this.writeIO((WorkItemNode)humanTaskNode, xmlDump);
        String ownerString = (String)humanTaskNode.getWork().getParameter("ActorId");
        if (ownerString != null) {
            String[] owners;
            for (String owner : owners = ownerString.split(",")) {
                xmlDump.append("      <potentialOwner resourceRef=\"tns:Actor\" >" + EOL + "        <resourceAssignmentExpression>" + EOL + "          <formalExpression>" + owner + "</formalExpression>" + EOL + "        </resourceAssignmentExpression>" + EOL + "      </potentialOwner>" + EOL);
            }
        }
        this.endNode("userTask", xmlDump);
    }

    protected void writeIO(WorkItemNode workItemNode, StringBuilder xmlDump) {
        xmlDump.append("      <ioSpecification>" + EOL);
        for (Map.Entry entry : workItemNode.getInMappings().entrySet()) {
            xmlDump.append("        <dataInput id=\"" + XmlBPMNProcessDumper.getUniqueNodeId((org.drools.definition.process.Node)workItemNode) + "_" + (String)entry.getKey() + "Input\" name=\"" + (String)entry.getKey() + "\" />" + EOL);
        }
        for (Map.Entry entry : workItemNode.getWork().getParameters().entrySet()) {
            if ("ActorId".equals(entry.getKey()) || entry.getValue() == null) continue;
            xmlDump.append("        <dataInput id=\"" + XmlBPMNProcessDumper.getUniqueNodeId((org.drools.definition.process.Node)workItemNode) + "_" + (String)entry.getKey() + "Input\" name=\"" + (String)entry.getKey() + "\" />" + EOL);
        }
        for (Map.Entry entry : workItemNode.getOutMappings().entrySet()) {
            xmlDump.append("        <dataOutput id=\"" + XmlBPMNProcessDumper.getUniqueNodeId((org.drools.definition.process.Node)workItemNode) + "_" + (String)entry.getKey() + "Output\" name=\"" + (String)entry.getKey() + "\" />" + EOL);
        }
        xmlDump.append("        <inputSet>" + EOL);
        for (Map.Entry entry : workItemNode.getInMappings().entrySet()) {
            xmlDump.append("          <dataInputRefs>" + XmlBPMNProcessDumper.getUniqueNodeId((org.drools.definition.process.Node)workItemNode) + "_" + (String)entry.getKey() + "Input</dataInputRefs>" + EOL);
        }
        for (Map.Entry entry : workItemNode.getWork().getParameters().entrySet()) {
            if ("ActorId".equals(entry.getKey()) || entry.getValue() == null) continue;
            xmlDump.append("          <dataInputRefs>" + XmlBPMNProcessDumper.getUniqueNodeId((org.drools.definition.process.Node)workItemNode) + "_" + (String)entry.getKey() + "Input</dataInputRefs>" + EOL);
        }
        xmlDump.append("        </inputSet>" + EOL);
        xmlDump.append("        <outputSet>" + EOL);
        for (Map.Entry entry : workItemNode.getOutMappings().entrySet()) {
            xmlDump.append("          <dataOutputRefs>" + XmlBPMNProcessDumper.getUniqueNodeId((org.drools.definition.process.Node)workItemNode) + "_" + (String)entry.getKey() + "Output</dataOutputRefs>" + EOL);
        }
        xmlDump.append("        </outputSet>" + EOL);
        xmlDump.append("      </ioSpecification>" + EOL);
        for (Map.Entry entry : workItemNode.getWork().getParameters().entrySet()) {
            if ("ActorId".equals(entry.getKey()) || entry.getValue() == null) continue;
            xmlDump.append("      <property id=\"" + XmlBPMNProcessDumper.getUniqueNodeId((org.drools.definition.process.Node)workItemNode) + "_" + (String)entry.getKey() + "\" />" + EOL);
        }
        for (Map.Entry entry : workItemNode.getInMappings().entrySet()) {
            xmlDump.append("      <dataInputAssociation>" + EOL);
            xmlDump.append("        <sourceRef>" + XmlBPMNProcessDumper.getUniqueNodeId((org.drools.definition.process.Node)workItemNode) + "_" + (String)entry.getValue() + "</sourceRef>" + EOL + "        <targetRef>" + XmlBPMNProcessDumper.getUniqueNodeId((org.drools.definition.process.Node)workItemNode) + "_" + (String)entry.getKey() + "</targetRef>" + EOL);
            xmlDump.append("      </dataInputAssociation>" + EOL);
        }
        for (Map.Entry entry : workItemNode.getWork().getParameters().entrySet()) {
            if ("ActorId".equals(entry.getKey()) || entry.getValue() == null) continue;
            xmlDump.append("      <dataInputAssociation>" + EOL);
            xmlDump.append("        <assignment>" + EOL + "          <from xs:type=\"tFormalExpression\">" + entry.getValue().toString() + "</from>" + EOL + "          <to xs:type=\"tFormalExpression\">" + XmlBPMNProcessDumper.getUniqueNodeId((org.drools.definition.process.Node)workItemNode) + "_" + (String)entry.getKey() + "Input</to>" + EOL + "        </assignment>" + EOL + "        <sourceRef>" + XmlBPMNProcessDumper.getUniqueNodeId((org.drools.definition.process.Node)workItemNode) + "_" + (String)entry.getKey() + "</sourceRef>" + EOL + "        <targetRef>" + XmlBPMNProcessDumper.getUniqueNodeId((org.drools.definition.process.Node)workItemNode) + "_" + (String)entry.getKey() + "Input</targetRef>" + EOL);
            xmlDump.append("      </dataInputAssociation>" + EOL);
        }
        for (Map.Entry entry : workItemNode.getOutMappings().entrySet()) {
            xmlDump.append("      <dataOutputAssociation>" + EOL);
            xmlDump.append("        <sourceRef>" + XmlBPMNProcessDumper.getUniqueNodeId((org.drools.definition.process.Node)workItemNode) + "_" + (String)entry.getKey() + "</sourceRef>" + EOL + "        <targetRef>" + XmlBPMNProcessDumper.getUniqueNodeId((org.drools.definition.process.Node)workItemNode) + "_" + (String)entry.getValue() + "</targetRef>" + EOL);
            xmlDump.append("      </dataOutputAssociation>" + EOL);
        }
    }
}

