/*
 * Decompiled with CFR 0.152.
 */
package org.drools.bpmn2.legacy.beta1.di;

import java.util.HashSet;
import org.drools.bpmn2.legacy.beta1.di.ProcessDiagramHandler;
import org.drools.bpmn2.legacy.beta1.di.ShapeHandler;
import org.drools.xml.BaseAbstractHandler;
import org.drools.xml.ExtensibleXmlParser;
import org.drools.xml.Handler;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SequenceFlowConnectorHandler
extends BaseAbstractHandler
implements Handler {
    public SequenceFlowConnectorHandler() {
        this.initValidParents();
        this.initValidPeers();
        this.allowNesting = false;
    }

    protected void initValidParents() {
        this.validParents = new HashSet();
        this.validParents.add(ProcessDiagramHandler.ProcessInfo.class);
    }

    protected void initValidPeers() {
        this.validPeers = new HashSet();
        this.validPeers.add(null);
        this.validPeers.add(ShapeHandler.NodeInfo.class);
        this.validPeers.add(ConnectionInfo.class);
    }

    public Object start(String uri, String localName, Attributes attrs, ExtensibleXmlParser parser) throws SAXException {
        parser.startElementBuilder(localName, attrs);
        String sequenceFlowRef = attrs.getValue("sequenceFlowRef");
        ConnectionInfo info = new ConnectionInfo(sequenceFlowRef);
        String sourceRef = attrs.getValue("sourceRef");
        String targetRef = attrs.getValue("targetRef");
        info.setSourceRef(sourceRef);
        info.setTargetRef(targetRef);
        ProcessDiagramHandler.ProcessInfo processInfo = (ProcessDiagramHandler.ProcessInfo)parser.getParent();
        processInfo.addConnectionInfo(info);
        return info;
    }

    public Object end(String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        Element element = parser.endElementBuilder();
        String bendpoints = null;
        Node xmlNode = element.getFirstChild();
        while (xmlNode instanceof Element) {
            String nodeName = xmlNode.getNodeName();
            if ("bendpoint".equals(nodeName)) {
                String x = ((Element)xmlNode).getAttribute("x");
                String y = ((Element)xmlNode).getAttribute("y");
                try {
                    int xValue = new Float(x).intValue();
                    int yValue = new Float(y).intValue();
                    bendpoints = bendpoints == null ? "[" : bendpoints + ";";
                    bendpoints = bendpoints + xValue + "," + yValue;
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Invalid bendpoint value", e);
                }
            }
            xmlNode = xmlNode.getNextSibling();
        }
        ConnectionInfo connectionInfo = (ConnectionInfo)parser.getCurrent();
        if (bendpoints != null) {
            connectionInfo.setBendpoints(bendpoints + "]");
        }
        return connectionInfo;
    }

    public Class<?> generateNodeFor() {
        return ConnectionInfo.class;
    }

    public static class ConnectionInfo {
        private String sequenceFlowRef;
        private String sourceRef;
        private String targetRef;
        private String bendpoints;

        public ConnectionInfo(String sequenceFlowRef) {
            this.sequenceFlowRef = sequenceFlowRef;
        }

        public String getSequenceFlowRef() {
            return this.sequenceFlowRef;
        }

        public String getSourceRef() {
            return this.sourceRef;
        }

        public void setSourceRef(String sourceRef) {
            this.sourceRef = sourceRef;
        }

        public String getTargetRef() {
            return this.targetRef;
        }

        public void setTargetRef(String targetRef) {
            this.targetRef = targetRef;
        }

        public String getBendpoints() {
            return this.bendpoints;
        }

        public void setBendpoints(String bendpoints) {
            this.bendpoints = bendpoints;
        }
    }
}

