/*
 * Decompiled with CFR 0.152.
 */
package org.drools.camel.component;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.impl.DefaultProducer;
import org.drools.camel.component.DroolsEndpoint;
import org.drools.grid.GridNode;
import org.kie.api.runtime.CommandExecutor;
import org.kie.api.runtime.rule.SessionEntryPoint;
import org.kie.internal.runtime.StatefulKnowledgeSession;
import org.kie.internal.runtime.StatelessKnowledgeSession;

public class DroolsInsertProducer
extends DefaultProducer {
    private DroolsEndpoint de;
    private InsertWorker worker;

    public DroolsInsertProducer(Endpoint endpoint, GridNode node) {
        super(endpoint);
        this.de = (DroolsEndpoint)endpoint;
        DroolsEndpoint.Action action = this.de.getAction();
        Unwrapper unwrapper = null;
        switch (action) {
            case INSERT_BODY: {
                unwrapper = BodyUnwrapper.INSTANCE;
                break;
            }
            case INSERT_MESSAGE: {
                unwrapper = MessageUnwrapper.INSTANCE;
                break;
            }
            case INSERT_EXCHANGE: {
                unwrapper = ExchangeUnwrapper.INSTANCE;
            }
        }
        CommandExecutor exec = this.de.getExecutor();
        if (exec instanceof StatefulKnowledgeSession) {
            String ep = this.de.getEntryPoint();
            SessionEntryPoint wmep = ep != null ? ((StatefulKnowledgeSession)exec).getEntryPoint(ep) : (SessionEntryPoint)exec;
            this.worker = new StatefulSessionInsertWorker(wmep, unwrapper);
        } else {
            this.worker = new StatelessSessionInsertWorker((StatelessKnowledgeSession)exec, unwrapper);
        }
    }

    public void process(Exchange exchange) throws Exception {
        this.worker.process(exchange);
    }

    private static class ExchangeUnwrapper
    implements Unwrapper {
        public static final ExchangeUnwrapper INSTANCE = new ExchangeUnwrapper();

        private ExchangeUnwrapper() {
        }

        @Override
        public Object getObject(Exchange exchange) {
            return exchange;
        }
    }

    private static class MessageUnwrapper
    implements Unwrapper {
        public static final MessageUnwrapper INSTANCE = new MessageUnwrapper();

        private MessageUnwrapper() {
        }

        @Override
        public Object getObject(Exchange exchange) {
            return exchange.getIn();
        }
    }

    private static class BodyUnwrapper
    implements Unwrapper {
        public static final BodyUnwrapper INSTANCE = new BodyUnwrapper();

        private BodyUnwrapper() {
        }

        @Override
        public Object getObject(Exchange exchange) {
            return exchange.getIn().getBody();
        }
    }

    private static interface Unwrapper {
        public Object getObject(Exchange var1);
    }

    private static class StatelessSessionInsertWorker
    implements InsertWorker {
        private StatelessKnowledgeSession ksession;
        private Unwrapper unwrapper;

        public StatelessSessionInsertWorker(StatelessKnowledgeSession ksession, Unwrapper unwrapper) {
            this.ksession = ksession;
            this.unwrapper = unwrapper;
        }

        @Override
        public void process(Exchange exchange) throws Exception {
            this.ksession.execute(this.unwrapper.getObject(exchange));
        }
    }

    private static class StatefulSessionInsertWorker
    implements InsertWorker {
        private SessionEntryPoint wmep;
        private Unwrapper unwrapper;

        public StatefulSessionInsertWorker(SessionEntryPoint wmep, Unwrapper unwrapper) {
            this.wmep = wmep;
            this.unwrapper = unwrapper;
        }

        @Override
        public void process(Exchange exchange) throws Exception {
            this.wmep.insert(this.unwrapper.getObject(exchange));
        }
    }

    private static interface InsertWorker {
        public void process(Exchange var1) throws Exception;
    }
}

