/*
 * Decompiled with CFR 0.152.
 */
package org.drools.camel.component;

import javax.naming.Context;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.drools.camel.component.DroolsCamelTestSupport;
import org.drools.pipeline.camel.Person;
import org.junit.Test;
import org.kie.internal.runtime.StatefulKnowledgeSession;

public class DroolsEndpointChannelTest
extends DroolsCamelTestSupport {
    private StatefulKnowledgeSession ksession;

    @Test
    public void testChannelSupport() throws Exception {
        Person bob1 = new Person("bob");
        Person bob2 = new Person("bob");
        Person bob3 = new Person("bob");
        Person mark1 = new Person("mark");
        MockEndpoint bobs = this.getMockEndpoint("mock:bobs");
        bobs.expectedMessageCount(3);
        bobs.expectedBodiesReceived(new Object[]{bob1, bob2, bob3});
        MockEndpoint marks = this.getMockEndpoint("mock:marks");
        marks.expectedMessageCount(1);
        marks.expectedBodiesReceived(new Object[]{mark1});
        this.ksession.insert((Object)bob1);
        this.ksession.insert((Object)mark1);
        this.ksession.fireAllRules();
        this.ksession.insert((Object)bob2);
        this.ksession.fireAllRules();
        this.ksession.insert((Object)bob3);
        this.ksession.fireAllRules();
        bobs.assertIsSatisfied();
        marks.assertIsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("drools://node/ksession1?channel=bobs").to("mock:bobs");
                this.from("drools://node/ksession1?channel=marks").to("mock:marks");
            }
        };
    }

    @Override
    protected void configureDroolsContext(Context jndiContext) {
        String rule = "";
        rule = rule + "package org.drools.pipeline.camel \n";
        rule = rule + "rule rule1 \n";
        rule = rule + "  when \n";
        rule = rule + "    $p : Person( name == 'bob' ) \n";
        rule = rule + "  then \n";
        rule = rule + "    channels[\"bobs\"].send( $p ); \n";
        rule = rule + "end\n";
        rule = rule + "rule rule2 \n";
        rule = rule + "  when \n";
        rule = rule + "    $p : Person( name == 'mark' ) \n";
        rule = rule + "  then \n";
        rule = rule + "    channels[\"marks\"].send( $p ); \n";
        rule = rule + "end\n";
        this.ksession = this.registerKnowledgeRuntime("ksession1", rule);
    }
}

