/*
 * Decompiled with CFR 0.152.
 */
package org.drools.camel.component;

import com.sun.tools.xjc.Language;
import com.sun.tools.xjc.Options;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.math.BigInteger;
import javax.naming.Context;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import org.apache.camel.CamelContext;
import org.apache.camel.Route;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.model.PolicyDefinition;
import org.apache.camel.model.dataformat.JaxbDataFormat;
import org.apache.camel.spi.Policy;
import org.drools.camel.component.DroolsCamelTestSupport;
import org.drools.camel.component.DroolsPolicy;
import org.drools.core.command.runtime.BatchExecutionCommandImpl;
import org.drools.core.command.runtime.rule.FireAllRulesCommand;
import org.drools.core.command.runtime.rule.InsertObjectCommand;
import org.drools.core.common.InternalRuleBase;
import org.drools.core.impl.KnowledgeBaseImpl;
import org.drools.core.reteoo.ReteooRuleBase;
import org.junit.Test;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.CommandExecutor;
import org.kie.api.runtime.ExecutionResults;
import org.kie.internal.KnowledgeBase;
import org.kie.internal.KnowledgeBaseFactoryService;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactoryService;
import org.kie.internal.builder.help.KnowledgeBuilderHelper;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.runtime.StatefulKnowledgeSession;

public class CamelEndpointWithJaxbXSDModelTest
extends DroolsCamelTestSupport {
    private JAXBContext jaxbContext;
    private ClassLoader classLoader;
    private RouteBuilder routeBuilder;

    @Test
    public void testSessionInsert() throws Exception {
        Class<?> personClass = this.classLoader.loadClass("org.drools.model.Person");
        CamelEndpointWithJaxbXSDModelTest.assertNotNull((Object)personClass.getPackage());
        Class<?> addressClass = this.classLoader.loadClass("org.drools.model.AddressType");
        CamelEndpointWithJaxbXSDModelTest.assertNotNull((Object)addressClass.getPackage());
        Object baunax = personClass.newInstance();
        Object lucaz = personClass.newInstance();
        Method setName = personClass.getMethod("setName", String.class);
        setName.invoke(baunax, "baunax");
        setName.invoke(lucaz, "lucaz");
        Method setAddress = personClass.getMethod("setAddress", addressClass);
        Method setStreet = addressClass.getMethod("setStreet", String.class);
        Method setPostalCode = addressClass.getMethod("setPostalCode", BigInteger.class);
        Object lucazAddress = addressClass.newInstance();
        setStreet.invoke(lucazAddress, "Unknow 342");
        setPostalCode.invoke(lucazAddress, new BigInteger("1234"));
        Object baunaxAddress = addressClass.newInstance();
        setStreet.invoke(baunaxAddress, "New Street 123");
        setPostalCode.invoke(baunaxAddress, new BigInteger("5678"));
        setAddress.invoke(lucaz, lucazAddress);
        setAddress.invoke(baunax, baunaxAddress);
        BatchExecutionCommandImpl cmd = new BatchExecutionCommandImpl();
        cmd.setLookup("ksession1");
        cmd.getCommands().add(new InsertObjectCommand(lucaz, "lucaz"));
        cmd.getCommands().add(new InsertObjectCommand(baunax, "baunax"));
        cmd.getCommands().add(new FireAllRulesCommand());
        StringWriter xmlReq = new StringWriter();
        Marshaller marshaller = this.getJaxbContext().createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        marshaller.marshal((Object)cmd, (Writer)xmlReq);
        System.out.println(xmlReq.toString());
        String xmlCmd = "";
        xmlCmd = xmlCmd + "<batch-execution lookup='ksession1'>\n";
        xmlCmd = xmlCmd + "   <insert out-identifier='lucaz'>\n";
        xmlCmd = xmlCmd + "    <object>\n";
        xmlCmd = xmlCmd + "      <Person xmlns='http://drools.org/model' >\n";
        xmlCmd = xmlCmd + "         <name>lucaz</name>\n";
        xmlCmd = xmlCmd + "         <age>25</age>\n";
        xmlCmd = xmlCmd + "      </Person>\n";
        xmlCmd = xmlCmd + "    </object>\n";
        xmlCmd = xmlCmd + "   </insert>\n";
        xmlCmd = xmlCmd + "   <insert out-identifier='baunax'>\n";
        xmlCmd = xmlCmd + "    <object>\n";
        xmlCmd = xmlCmd + "      <Person xmlns='http://drools.org/model' >\n";
        xmlCmd = xmlCmd + "         <name>baunax</name>\n";
        xmlCmd = xmlCmd + "         <age>21</age>\n";
        xmlCmd = xmlCmd + "      </Person>\n";
        xmlCmd = xmlCmd + "    </object>\n";
        xmlCmd = xmlCmd + "   </insert>\n";
        xmlCmd = xmlCmd + "   <fire-all-rules />";
        xmlCmd = xmlCmd + "</batch-execution>\n";
        byte[] xmlResp = (byte[])this.template.requestBody("direct:test-with-session", (Object)xmlReq.toString());
        CamelEndpointWithJaxbXSDModelTest.assertNotNull((Object)xmlResp);
        System.out.println(new String(xmlResp));
        ExecutionResults resp = (ExecutionResults)this.getJaxbContext().createUnmarshaller().unmarshal((InputStream)new ByteArrayInputStream(xmlResp));
        CamelEndpointWithJaxbXSDModelTest.assertNotNull((Object)resp);
        CamelEndpointWithJaxbXSDModelTest.assertEquals((long)2L, (long)resp.getIdentifiers().size());
        CamelEndpointWithJaxbXSDModelTest.assertNotNull((Object)resp.getValue("lucaz"));
        CamelEndpointWithJaxbXSDModelTest.assertNotNull((Object)resp.getValue("baunax"));
        CamelEndpointWithJaxbXSDModelTest.assertNotNull((Object)resp.getFactHandle("lucaz"));
        CamelEndpointWithJaxbXSDModelTest.assertNotNull((Object)resp.getFactHandle("baunax"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JAXBContext getJaxbContext() {
        if (this.jaxbContext == null) {
            JaxbDataFormat def = new JaxbDataFormat();
            def.setPrettyPrint(Boolean.valueOf(true));
            def.setContextPath("org.drools.model:org.drools.pipeline.camel");
            StatefulKnowledgeSession ksession1 = (StatefulKnowledgeSession)this.node.get("ksession1", CommandExecutor.class);
            KnowledgeBase kbase = ksession1.getKieBase();
            ClassLoader originalCl = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(((ReteooRuleBase)((KnowledgeBaseImpl)kbase).getRuleBase()).getRootClassLoader());
                def = DroolsPolicy.augmentJaxbDataFormatDefinition((JaxbDataFormat)def);
                org.apache.camel.converter.jaxb.JaxbDataFormat jaxbDataformat = (org.apache.camel.converter.jaxb.JaxbDataFormat)def.getDataFormat(((Route)this.context.getRoutes().get(0)).getRouteContext());
                jaxbDataformat.setCamelContext((CamelContext)this.routeBuilder.getContext());
                try {
                    jaxbDataformat.start();
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
                this.jaxbContext = jaxbDataformat.getContext();
            }
            finally {
                Thread.currentThread().setContextClassLoader(originalCl);
            }
        }
        return this.jaxbContext;
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        this.routeBuilder = new RouteBuilder(){

            public void configure() throws Exception {
                JaxbDataFormat def = new JaxbDataFormat();
                def.setPrettyPrint(Boolean.valueOf(true));
                def.setContextPath("org.drools.pipeline.camel");
                ((PolicyDefinition)((PolicyDefinition)this.from("direct:test-with-session").policy((Policy)new DroolsPolicy()).unmarshal((DataFormatDefinition)def)).to("drools:node/ksession1")).marshal((DataFormatDefinition)def);
            }
        };
        return this.routeBuilder;
    }

    @Override
    protected void configureDroolsContext(Context jndiContext) {
        String rule = "";
        rule = rule + "package org.drools.pipeline.camel.test \n";
        rule = rule + "import org.drools.model.Person \n";
        rule = rule + "global java.util.List list \n";
        rule = rule + "query persons \n";
        rule = rule + "   $p : Person(name != null) \n";
        rule = rule + "end \n";
        rule = rule + "query personWithName(String param)\n";
        rule = rule + "   $p : Person(name == param) \n";
        rule = rule + "end \n";
        rule = rule + "rule rule1 \n";
        rule = rule + "  when \n";
        rule = rule + "    $p : Person() \n";
        rule = rule + " \n";
        rule = rule + "  then \n";
        rule = rule + "    System.out.println(\"executed\"); \n";
        rule = rule + "end\n";
        this.registerKnowledgeRuntime("ksession1", rule);
    }

    @Override
    protected StatefulKnowledgeSession registerKnowledgeRuntime(String identifier, String rule) {
        KnowledgeBuilder kbuilder = ((KnowledgeBuilderFactoryService)this.node.get(KnowledgeBuilderFactoryService.class)).newKnowledgeBuilder();
        Options xjcOpts = new Options();
        xjcOpts.setSchemaLanguage(Language.XMLSCHEMA);
        try {
            KnowledgeBuilderHelper.addXsdModel((Resource)ResourceFactory.newClassPathResource((String)"person.xsd", ((Object)((Object)this)).getClass()), (KnowledgeBuilder)kbuilder, (Options)xjcOpts, (String)"xsd");
        }
        catch (IOException e) {
            LOG.error("Errors while adding xsd model. ", (Object)kbuilder.getErrors());
        }
        CamelEndpointWithJaxbXSDModelTest.assertFalse((boolean)kbuilder.hasErrors());
        if (rule != null && rule.length() > 0) {
            kbuilder.add(ResourceFactory.newByteArrayResource((byte[])rule.getBytes()), ResourceType.DRL);
            if (kbuilder.hasErrors()) {
                LOG.info("Errors while adding rule. ", (Object)kbuilder.getErrors());
            }
        }
        CamelEndpointWithJaxbXSDModelTest.assertFalse((String)kbuilder.getErrors().toString(), (boolean)kbuilder.hasErrors());
        KnowledgeBase kbase = ((KnowledgeBaseFactoryService)this.node.get(KnowledgeBaseFactoryService.class)).newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        this.classLoader = ((InternalRuleBase)((KnowledgeBaseImpl)kbase).getRuleBase()).getRootClassLoader();
        StatefulKnowledgeSession session = kbase.newStatefulKnowledgeSession();
        this.node.set(identifier, (Object)session);
        return session;
    }
}

