/*
 * Decompiled with CFR 0.152.
 */
package org.drools.camel.component;

import java.util.Arrays;
import javax.naming.Context;
import org.apache.camel.builder.RouteBuilder;
import org.drools.camel.component.DroolsCamelTestSupport;
import org.drools.core.command.runtime.BatchExecutionCommandImpl;
import org.drools.core.command.runtime.rule.InsertObjectCommand;
import org.drools.pipeline.camel.Person;
import org.junit.Test;
import org.kie.api.command.Command;
import org.kie.api.runtime.ExecutionResults;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.internal.command.CommandFactory;
import org.kie.internal.runtime.StatefulKnowledgeSession;

public class CamelProxyEndpointTest
extends DroolsCamelTestSupport {
    private String handle;

    @Test
    public void testSessionInsert() throws Exception {
        Person person = new Person();
        person.setName("Mauricio");
        InsertObjectCommand cmd = (InsertObjectCommand)CommandFactory.newInsert((Object)person, (String)"salaboy");
        ExecutionResults response = (ExecutionResults)this.template.requestBody("direct:test-no-marshal", (Object)cmd);
        CamelProxyEndpointTest.assertTrue((String)"Expected valid ExecutionResults object", (response != null ? 1 : 0) != 0);
        CamelProxyEndpointTest.assertTrue((String)"ExecutionResults missing expected fact", (response.getFactHandle("salaboy") != null ? 1 : 0) != 0);
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:test-no-marshal").to("drools://node/ksession1");
            }
        };
    }

    @Override
    protected void configureDroolsContext(Context jndiContext) {
        Person me = new Person();
        me.setName("Hadrian");
        StatefulKnowledgeSession ksession = this.registerKnowledgeRuntime("ksession1", null);
        InsertObjectCommand cmd = new InsertObjectCommand((Object)me);
        cmd.setOutIdentifier("camel-rider");
        cmd.setReturnObject(false);
        BatchExecutionCommandImpl script = new BatchExecutionCommandImpl(Arrays.asList(cmd));
        ExecutionResults results = (ExecutionResults)ksession.execute((Command)script);
        this.handle = ((FactHandle)results.getFactHandle("camel-rider")).toExternalForm();
    }
}

