/*
 * Decompiled with CFR 0.152.
 */
package org.drools.camel.component;

import java.net.URI;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.DefaultComponent;
import org.apache.camel.impl.DefaultEndpoint;
import org.drools.camel.component.DroolsEndpoint;
import org.drools.camel.component.DroolsProxyEndpoint;
import org.drools.grid.ExecutionNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DroolsComponent
extends DefaultComponent {
    public static final String DROOLS_LOOKUP = "DroolsLookup";
    public static final String DROOLS_OUT_IDENTIFIER = "DroolsOutIdentifier";
    public static final String DROOLS_HANDLE = "DroolsHandle";
    private static final String EMBEDDED_SCHEME = "drools-embedded";
    private static final String UUID_PREFIX = "drools-";
    private static final AtomicInteger counter = new AtomicInteger();
    private CamelContext embeddedContext;
    private ExecutionNode node;
    private String nodeId = "";

    public DroolsComponent() {
    }

    public DroolsComponent(CamelContext context) {
        super(context);
    }

    public CamelContext getEmbeddedContext() {
        if (this.embeddedContext == null) {
            this.createEmbeddedContext();
        }
        return this.embeddedContext;
    }

    public void setEmbeddedContext(CamelContext context) {
        this.embeddedContext = context;
    }

    public String getExecutionNodeId() {
        return this.nodeId;
    }

    public void setExecutionNodeId(String nodeId) {
        this.nodeId = nodeId == null ? "" : nodeId;
    }

    public ExecutionNode getExecutionNode() {
        return this.node;
    }

    public void setExecutionNode(ExecutionNode node) {
        this.node = node;
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        DefaultEndpoint endpoint = EMBEDDED_SCHEME.equals(new URI(uri).getScheme()) ? new DroolsEndpoint(uri, remaining, this) : new DroolsProxyEndpoint(uri, remaining, this);
        this.setProperties(endpoint, parameters);
        return endpoint;
    }

    protected void createEmbeddedContext() {
        if (this.embeddedContext == null) {
            DefaultCamelContext context;
            try {
                context = new DefaultCamelContext(this.getCamelContext().getRegistry());
                context.disableJMX();
                context.start();
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
            this.embeddedContext = context;
        }
    }

    public static final String getSessionManagerId(String uri) {
        int pos = uri.indexOf(47);
        return pos < 0 ? uri : uri.substring(0, pos);
    }

    public static final String getKsessionId(String uri) {
        int pos = uri.indexOf(47);
        return pos < 0 ? "" : uri.substring(pos + 1);
    }

    public static final String generateUuid() {
        return UUID_PREFIX + counter.incrementAndGet();
    }

    protected void validateParameters(String uri, Map<String, Object> parameters, String optionPrefix) {
    }
}

