/*
 * Decompiled with CFR 0.152.
 */
package org.drools.camel.component;

import java.net.URISyntaxException;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.impl.DefaultEndpoint;
import org.drools.builder.DirectoryLookupFactoryService;
import org.drools.camel.component.DroolsComponent;
import org.drools.camel.component.DroolsProducer;
import org.drools.grid.ExecutionNode;
import org.drools.runtime.CommandExecutor;

public class DroolsEndpoint
extends DefaultEndpoint {
    private String ksession;
    private String pipeline;
    private CommandExecutor executor;
    private ExecutionNode node;

    public DroolsEndpoint(String endpointUri, String remaining, DroolsComponent component) throws URISyntaxException {
        super(endpointUri, (Component)component);
        this.configure(component, remaining);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new RuntimeCamelException("Drools consumers not supported.");
    }

    public Producer createProducer() throws Exception {
        return new DroolsProducer((Endpoint)this, this.node);
    }

    public boolean isSingleton() {
        return true;
    }

    public String getKsession() {
        return this.ksession;
    }

    public void setKsession(String ksession) {
        this.ksession = ksession;
    }

    public String getPipeline() {
        return this.pipeline;
    }

    public void setPipeline(String pipeline) {
        this.pipeline = pipeline;
    }

    public CommandExecutor getExecutor() {
        return this.executor;
    }

    public ExecutionNode getExecutionNode() {
        return this.node;
    }

    protected void configure(DroolsComponent component, String uri) {
        String smId = DroolsComponent.getSessionManagerId(uri);
        this.ksession = DroolsComponent.getKsessionId(uri);
        if (smId.length() > 0) {
            this.node = component.getExecutionNode();
            if (this.node == null) {
                this.node = (ExecutionNode)component.getCamelContext().getRegistry().lookup(smId, ExecutionNode.class);
                if (this.node == null) {
                    throw new RuntimeCamelException("Could not find ServiceManager with id=\"" + smId + "\" in CamelContext. Check configuration.");
                }
                component.setExecutionNodeId(smId);
                component.setExecutionNode(this.node);
            } else if (!smId.equals(component.getExecutionNodeId())) {
                throw new RuntimeCamelException("ServiceManager already initialized from id=\"" + component.getExecutionNodeId() + "\" yet current endpoint requries id=\"" + smId + "\"");
            }
            if (this.ksession.length() > 0) {
                this.executor = ((DirectoryLookupFactoryService)this.node.get(DirectoryLookupFactoryService.class)).lookup(this.ksession);
                if (this.executor == null) {
                    throw new RuntimeCamelException("Failed to instantiate DroolsEndpoint. Lookup of CommandExecutor with id=\"" + uri + "\" failed. Check configuration.");
                }
            }
        } else {
            this.executor = (CommandExecutor)component.getCamelContext().getRegistry().lookup(this.ksession, CommandExecutor.class);
        }
    }
}

