/*
 * Decompiled with CFR 0.152.
 */
package org.drools.camel.component;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.impl.DefaultProducer;
import org.drools.builder.DirectoryLookupFactoryService;
import org.drools.camel.component.DroolsEndpoint;
import org.drools.command.Command;
import org.drools.grid.ExecutionNode;
import org.drools.runtime.CommandExecutor;
import org.drools.runtime.ExecutionResults;
import org.drools.runtime.pipeline.ResultHandler;

public class DroolsProducer
extends DefaultProducer {
    private ExecutionNode node;
    private CommandExecutor executor;

    public DroolsProducer(Endpoint endpoint, ExecutionNode node) {
        super(endpoint);
        this.node = node;
        DroolsEndpoint de = (DroolsEndpoint)endpoint;
        this.executor = ((DirectoryLookupFactoryService)node.get(DirectoryLookupFactoryService.class)).lookup(de.getKsession());
    }

    public void process(Exchange exchange) throws Exception {
        Command cmd;
        CommandExecutor exec = this.executor;
        if (exec == null) {
            String ksession = (String)exchange.getIn().getHeader("DroolsLookup", String.class);
            exec = ((DirectoryLookupFactoryService)this.node.get(DirectoryLookupFactoryService.class)).lookup(ksession == null ? "" : ksession);
            if (exec == null) {
                throw new RuntimeCamelException("Null executor");
            }
        }
        if ((cmd = (Command)exchange.getIn().getBody(Command.class)) == null) {
            throw new RuntimeCamelException("Body of in message not of the expected type 'org.drools.command.Command'");
        }
        ExecutionResults results = exec.execute(cmd);
        exchange.getOut().setBody((Object)results);
    }

    public static class ResultHandlerImpl
    implements ResultHandler {
        Object object;

        public void handleResult(Object object) {
            this.object = object;
        }

        public Object getObject() {
            return this.object;
        }
    }
}

