/*
 * Decompiled with CFR 0.152.
 */
package org.drools.camel.component;

import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.model.ProcessorDefinition;
import org.drools.camel.component.DroolsComponent;
import org.drools.camel.component.DroolsProxyProducer;
import org.drools.grid.ExecutionNode;
import org.drools.pipeline.camel.DroolsCamelContextInit;

public class DroolsProxyEndpoint
extends DefaultEndpoint {
    private String id;
    private String uri;
    private String dataFormat;
    private String marshall;
    private String unmarshall;
    private RouteBuilder builder;

    public DroolsProxyEndpoint(String endpointUri, String remaining, DroolsComponent component) throws Exception {
        super(endpointUri, (Component)component);
        this.configure(component, remaining);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new RuntimeCamelException("Drools consumers not supported.");
    }

    public Producer createProducer() throws Exception {
        if (this.builder == null) {
            String smId = DroolsComponent.getSessionManagerId(this.uri);
            final ExecutionNode node = (ExecutionNode)this.getCamelContext().getRegistry().lookup(smId);
            if (node == null) {
                throw new RuntimeCamelException("Cannot find ServiceManager instance with id=\"" + smId + "\" in the CamelContext registry.");
            }
            final String inFormat = this.dataFormat == null ? this.unmarshall : this.dataFormat;
            final String outFormat = this.dataFormat == null ? this.marshall : this.dataFormat;
            this.builder = new RouteBuilder(){

                public void configure() throws Exception {
                    ProcessorDefinition pipeline = this.from("direct:" + DroolsProxyEndpoint.this.id).bean((Object)new DroolsCamelContextInit(node));
                    if (inFormat != null) {
                        pipeline = pipeline.unmarshal(inFormat);
                    }
                    pipeline = pipeline.to("drools-embedded:" + DroolsProxyEndpoint.this.uri);
                    if (inFormat != null) {
                        pipeline = pipeline.marshal(outFormat);
                    }
                }
            };
            this.getEmbeddedContext().addRoutes((RoutesBuilder)this.builder);
        }
        return new DroolsProxyProducer((Endpoint)this);
    }

    public boolean isSingleton() {
        return true;
    }

    protected void configure(DroolsComponent component, String uri) throws Exception {
        this.uri = uri;
        this.id = DroolsComponent.generateUuid();
    }

    public boolean isLenientProperties() {
        return true;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getDataFormat() {
        return this.dataFormat;
    }

    public void setDataFormat(String dataFormat) {
        this.dataFormat = dataFormat;
    }

    public String getMarshall() {
        return this.marshall;
    }

    public void setMarshall(String marshall) {
        this.marshall = marshall;
    }

    public String getUnmarshall() {
        return this.unmarshall;
    }

    public void setUnmarshall(String unmarshall) {
        this.unmarshall = unmarshall;
    }

    public CamelContext getEmbeddedContext() {
        return ((DroolsComponent)this.getComponent()).getEmbeddedContext();
    }
}

