/*
 * Decompiled with CFR 0.152.
 */
package org.drools.camel.component;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.util.ExchangeHelper;
import org.drools.camel.component.DroolsProxyEndpoint;

public class DroolsProxyProducer
extends DefaultProducer {
    private Endpoint droolsEndpoint;
    private ProducerTemplate template;

    public DroolsProxyProducer(Endpoint endpoint) {
        super(endpoint);
        DroolsProxyEndpoint de = (DroolsProxyEndpoint)endpoint;
        this.droolsEndpoint = de.getEmbeddedContext().getEndpoint("direct:" + de.getId());
        this.template = endpoint.getCamelContext().createProducerTemplate();
    }

    public void process(Exchange exchange) throws Exception {
        Exchange result = this.template.send(this.droolsEndpoint, exchange.copy());
        exchange.getOut().copyFrom(ExchangeHelper.getResultMessage((Exchange)result));
    }
}

