/*
 * Decompiled with CFR 0.152.
 */
package org.drools.camel.component;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.xml.DomReader;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.camel.Exchange;
import org.apache.camel.spi.DataFormat;
import org.drools.builder.DirectoryLookupFactoryService;
import org.drools.command.impl.CommandBasedStatefulKnowledgeSession;
import org.drools.grid.ExecutionNode;
import org.drools.impl.KnowledgeBaseImpl;
import org.drools.impl.StatefulKnowledgeSessionImpl;
import org.drools.impl.StatelessKnowledgeSessionImpl;
import org.drools.reteoo.ReteooRuleBase;
import org.drools.rule.DroolsCompositeClassLoader;
import org.drools.runtime.CommandExecutor;
import org.drools.runtime.help.BatchExecutionHelper;
import org.drools.runtime.pipeline.PipelineContext;
import org.drools.runtime.pipeline.impl.ExecutionNodePipelineContextImpl;
import org.drools.runtime.pipeline.impl.XStreamResolverStrategy;
import org.w3c.dom.Document;

public class DroolsXStreamDataFormat
implements DataFormat {
    private XStreamResolverStrategy xstreamStrategy = new XStreamResolverStrategy(){

        public XStream lookup(String name) {
            return BatchExecutionHelper.newXStreamMarshaller();
        }
    };
    private String charset;

    public void marshal(Exchange exchange, Object graph, OutputStream stream) throws Exception {
        PipelineContext context = (PipelineContext)exchange.getProperty("drools-context");
        XStream xstream = (XStream)context.getProperties().get("xstream-instance");
        xstream.setClassLoader(context.getClassLoader());
        String result = null;
        result = xstream.toXML(exchange.getIn().getBody());
        byte[] bytes = this.charset != null ? result.getBytes(this.charset) : result.getBytes();
        stream.write(bytes);
    }

    public Object unmarshal(Exchange exchange, InputStream stream) throws Exception {
        try {
            PipelineContext context = (PipelineContext)exchange.getProperty("drools-context");
            Document d = (Document)exchange.getIn().getBody(Document.class);
            String name = d.getDocumentElement().getAttribute("lookup");
            XStream xstream = this.xstreamStrategy.lookup(name);
            if (xstream == null) {
                throw new IllegalArgumentException("Unable to lookup XStream parser using name '" + name + "'");
            }
            ExecutionNodePipelineContextImpl executionNodeContext = (ExecutionNodePipelineContextImpl)exchange.getProperty("drools-context");
            ExecutionNode node = executionNodeContext.getExecutionNode();
            CommandExecutor executor = ((DirectoryLookupFactoryService)node.get(DirectoryLookupFactoryService.class)).lookup(name);
            if (executor == null) {
                throw new IllegalArgumentException("Unable to lookup CommandExecutor using name '" + name + "'");
            }
            executionNodeContext.setCommandExecutor(executor);
            DroolsCompositeClassLoader cl = null;
            if (executor instanceof StatefulKnowledgeSessionImpl) {
                cl = ((ReteooRuleBase)((StatefulKnowledgeSessionImpl)executor).getRuleBase()).getRootClassLoader();
                xstream.setClassLoader((ClassLoader)cl);
            } else if (executor instanceof StatelessKnowledgeSessionImpl) {
                cl = ((ReteooRuleBase)((StatelessKnowledgeSessionImpl)executor).getRuleBase()).getRootClassLoader();
            } else if (executor instanceof CommandBasedStatefulKnowledgeSession) {
                cl = ((ReteooRuleBase)((KnowledgeBaseImpl)((CommandBasedStatefulKnowledgeSession)executor).getKnowledgeBase()).getRuleBase()).getRootClassLoader();
            } else {
                throw new IllegalArgumentException("Unable to set ClassLoader on " + executor);
            }
            xstream.setClassLoader((ClassLoader)cl);
            executionNodeContext.setClassLoader((ClassLoader)cl);
            Object payload = xstream.unmarshal((HierarchicalStreamReader)new DomReader(d));
            executionNodeContext.getProperties().put("xstream-instance", xstream);
            exchange.setProperty("drools-context", (Object)executionNodeContext);
            return payload;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }
}

