/*
 * Decompiled with CFR 0.152.
 */
package org.drools.camel.component;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.model.BeanDefinition;
import org.apache.camel.model.MarshalDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.ToDefinition;
import org.apache.camel.model.UnmarshalDefinition;
import org.apache.camel.model.dataformat.JaxbDataFormat;
import org.apache.camel.model.dataformat.XStreamDataFormat;
import org.apache.camel.spi.Policy;
import org.apache.camel.spi.RouteContext;
import org.drools.camel.component.DroolsEndpoint;
import org.drools.camel.component.ExecutionNodePipelineContextImpl;
import org.drools.camel.component.FastCloner;
import org.drools.camel.component.PostCxfrs;
import org.drools.camel.component.PreCxfrs;
import org.drools.camel.component.XStreamJson;
import org.drools.camel.component.XStreamXml;
import org.drools.command.runtime.BatchExecutionCommandImpl;
import org.drools.command.runtime.GetGlobalCommand;
import org.drools.command.runtime.SetGlobalCommand;
import org.drools.command.runtime.process.AbortWorkItemCommand;
import org.drools.command.runtime.process.CompleteWorkItemCommand;
import org.drools.command.runtime.process.SignalEventCommand;
import org.drools.command.runtime.process.StartProcessCommand;
import org.drools.command.runtime.rule.FireAllRulesCommand;
import org.drools.command.runtime.rule.GetObjectsCommand;
import org.drools.command.runtime.rule.InsertElementsCommand;
import org.drools.command.runtime.rule.InsertObjectCommand;
import org.drools.command.runtime.rule.ModifyCommand;
import org.drools.command.runtime.rule.QueryCommand;
import org.drools.command.runtime.rule.RetractCommand;
import org.drools.common.DefaultFactHandle;
import org.drools.core.util.StringUtils;
import org.drools.runtime.CommandExecutor;
import org.drools.runtime.impl.ExecutionResultImpl;
import org.drools.runtime.rule.impl.FlatQueryResults;
import org.drools.xml.jaxb.util.JaxbListWrapper;

public class DroolsPolicy
implements Policy {
    private DroolsEndpoint dep;
    public static final String[] JAXB_ANNOTATED_CMD = new String[]{BatchExecutionCommandImpl.class.getName(), SetGlobalCommand.class.getName(), GetGlobalCommand.class.getName(), FireAllRulesCommand.class.getName(), InsertElementsCommand.class.getName(), InsertObjectCommand.class.getName(), ModifyCommand.class.getName(), ModifyCommand.SetterImpl.class.getName(), QueryCommand.class.getName(), RetractCommand.class.getName(), AbortWorkItemCommand.class.getName(), SignalEventCommand.class.getName(), StartProcessCommand.class.getName(), BatchExecutionCommandImpl.class.getName(), ExecutionResultImpl.class.getName(), DefaultFactHandle.class.getName(), JaxbListWrapper.class.getName(), FlatQueryResults.class.getName(), CompleteWorkItemCommand.class.getName(), GetObjectsCommand.class.getName()};

    public void beforeWrap(RouteContext routeContext, ProcessorDefinition processorDefinition) {
        DroolsPolicy.augmentNodes(routeContext, processorDefinition, new HashSet());
    }

    public Processor wrap(RouteContext routeContext, Processor processor) {
        RouteDefinition routeDef = routeContext.getRoute();
        ToDefinition toDrools = this.getDroolsNode(routeDef);
        Processor returnedProcessor = toDrools != null ? new DroolsProcess(toDrools.getUri(), processor) : processor;
        return returnedProcessor;
    }

    private ToDefinition getDroolsNode(RouteDefinition routeDef) {
        ProcessorDefinition child;
        ToDefinition toDrools = null;
        Iterator i$ = routeDef.getOutputs().iterator();
        while (i$.hasNext() && (toDrools = this.getDroolsNode(child = (ProcessorDefinition)i$.next())) == null) {
        }
        return toDrools;
    }

    public static void augmentNodes(RouteContext routeContext, ProcessorDefinition nav, Set visited) {
        if (!nav.getOutputs().isEmpty()) {
            List outputs = nav.getOutputs();
            for (int i = 0; i < outputs.size(); ++i) {
                XStreamDataFormat xstreamDataFormat;
                String ref;
                Object dformatDefinition;
                MarshalDefinition m;
                ProcessorDefinition child = (ProcessorDefinition)outputs.get(i);
                if (child instanceof ToDefinition) {
                    ToDefinition to = (ToDefinition)child;
                    if (!to.getUri().startsWith("cxfrs") || visited.contains(to)) continue;
                    BeanDefinition beanDef = new BeanDefinition();
                    beanDef.setBeanType(PreCxfrs.class);
                    outputs.add(i, beanDef);
                    beanDef = new BeanDefinition();
                    beanDef.setBeanType(PostCxfrs.class);
                    outputs.add(i + 2, beanDef);
                    i += 2;
                    continue;
                }
                if (child instanceof MarshalDefinition) {
                    m = (MarshalDefinition)child;
                    dformatDefinition = m.getDataFormatType();
                    if (dformatDefinition == null) {
                        ref = m.getRef();
                        if ("json".equals(ref)) {
                            dformatDefinition = new XStreamDataFormat();
                            ((XStreamDataFormat)dformatDefinition).setDriver("json");
                        } else {
                            dformatDefinition = "xstream".equals(ref) ? new XStreamDataFormat() : ("jaxb".equals(ref) ? new JaxbDataFormat() : routeContext.getCamelContext().resolveDataFormatDefinition(ref));
                        }
                    }
                    if ((dformatDefinition = new FastCloner().deepClone(dformatDefinition)) instanceof JaxbDataFormat) {
                        dformatDefinition = DroolsPolicy.augmentJaxbDataFormatDefinition((JaxbDataFormat)dformatDefinition);
                    } else if (dformatDefinition instanceof XStreamDataFormat) {
                        xstreamDataFormat = (XStreamDataFormat)dformatDefinition;
                        dformatDefinition = "json".equals(xstreamDataFormat.getDriver()) ? XStreamJson.newJSonMarshaller(xstreamDataFormat) : XStreamXml.newXStreamMarshaller((XStreamDataFormat)dformatDefinition);
                    }
                    m.setDataFormatType(dformatDefinition);
                    continue;
                }
                if (!(child instanceof UnmarshalDefinition)) continue;
                m = (UnmarshalDefinition)child;
                dformatDefinition = m.getDataFormatType();
                if (dformatDefinition == null) {
                    ref = m.getRef();
                    if ("json".equals(ref)) {
                        dformatDefinition = new XStreamDataFormat();
                        ((XStreamDataFormat)dformatDefinition).setDriver("json");
                    } else {
                        dformatDefinition = "xstream".equals(ref) ? new XStreamDataFormat() : ("jaxb".equals(ref) ? new JaxbDataFormat() : routeContext.getCamelContext().resolveDataFormatDefinition(ref));
                    }
                }
                if ((dformatDefinition = new FastCloner().deepClone(dformatDefinition)) instanceof JaxbDataFormat) {
                    dformatDefinition = DroolsPolicy.augmentJaxbDataFormatDefinition((JaxbDataFormat)dformatDefinition);
                } else if (dformatDefinition instanceof XStreamDataFormat) {
                    xstreamDataFormat = (XStreamDataFormat)dformatDefinition;
                    dformatDefinition = "json".equals(xstreamDataFormat.getDriver()) ? XStreamJson.newJSonMarshaller(xstreamDataFormat) : XStreamXml.newXStreamMarshaller((XStreamDataFormat)dformatDefinition);
                }
                m.setDataFormatType(dformatDefinition);
            }
            for (ProcessorDefinition child : nav.getOutputs()) {
                DroolsPolicy.augmentNodes(routeContext, child, visited);
            }
        }
    }

    private ToDefinition getDroolsNode(ProcessorDefinition nav) {
        if (!nav.getOutputs().isEmpty()) {
            List children = nav.getOutputs();
            for (ProcessorDefinition child : children) {
                ToDefinition to;
                if (child instanceof ToDefinition && (to = (ToDefinition)child).getUri().trim().startsWith("drools:")) {
                    return to;
                }
                this.getDroolsNode(child);
            }
        }
        return null;
    }

    public static JaxbDataFormat augmentJaxbDataFormatDefinition(JaxbDataFormat jaxbDataFormat) {
        HashSet<String> set = new HashSet<String>();
        for (String clsName : JAXB_ANNOTATED_CMD) {
            set.add(clsName.substring(0, clsName.lastIndexOf(46)));
        }
        StringBuilder sb = new StringBuilder();
        sb.append(jaxbDataFormat.getContextPath());
        sb.append(":");
        for (String pkgName : set) {
            sb.append(pkgName);
            sb.append(':');
        }
        jaxbDataFormat.setContextPath(sb.toString());
        return jaxbDataFormat;
    }

    public static class DroolsProcess
    implements Processor {
        private String droolsUri;
        private DroolsEndpoint dep;
        private Processor processor;

        public DroolsProcess(String droolsUri, Processor processor) {
            this.droolsUri = droolsUri;
            this.processor = processor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void process(Exchange exchange) throws Exception {
            if (this.dep == null) {
                this.dep = (DroolsEndpoint)exchange.getContext().getEndpoint(this.droolsUri, DroolsEndpoint.class);
            }
            if (this.dep == null) {
                throw new RuntimeException("Could not find DroolsEndPoint for uri=" + this.droolsUri);
            }
            ClassLoader originalClassLoader = null;
            try {
                originalClassLoader = Thread.currentThread().getContextClassLoader();
                CommandExecutor exec = this.dep.executor;
                if (exec == null) {
                    String lookup = (String)exchange.getIn().getHeader("DroolsLookup", String.class);
                    if (StringUtils.isEmpty((CharSequence)lookup)) {
                        lookup = this.dep.getLookup((String)exchange.getIn().getBody(String.class));
                    }
                    if (StringUtils.isEmpty((CharSequence)lookup)) {
                        throw new RuntimeException("No Executor defined and no lookup information available for uri " + this.dep.getEndpointUri());
                    }
                    exec = this.dep.getCommandExecutor(lookup);
                }
                if (exec == null) {
                    throw new RuntimeException("CommandExecutor cannot be found for uri " + this.dep.getEndpointUri());
                }
                ClassLoader localClassLoader = this.dep.getClassLoader(exec);
                if (localClassLoader == null) {
                    throw new RuntimeException("CommandExecutor Classloader cannot be null for uri " + this.dep.getEndpointUri());
                }
                Thread.currentThread().setContextClassLoader(localClassLoader);
                ExecutionNodePipelineContextImpl context = new ExecutionNodePipelineContextImpl(this.dep.node, localClassLoader);
                context.setCommandExecutor(exec);
                exchange.setProperty("drools-context", (Object)context);
                this.processor.process(exchange);
            }
            finally {
                Thread.currentThread().setContextClassLoader(originalClassLoader);
            }
        }
    }

    public static class DroolsClientProcessor
    implements Processor {
        private Processor processor;

        public DroolsClientProcessor(Processor processor) {
            this.processor = processor;
        }

        public void process(Exchange exchange) throws Exception {
            exchange.setPattern(ExchangePattern.InOut);
            Message inMessage = exchange.getIn();
            inMessage.setHeader("CamelCxfRsUsingHttpAPI", (Object)Boolean.TRUE);
            inMessage.setHeader("CamelHttpMethod", (Object)"POST");
            inMessage.setHeader("CamelHttpPath", (Object)"/execute");
            inMessage.setHeader("CamelAcceptContentType", (Object)"text/plain");
            inMessage.setHeader("Content-Type", (Object)"text/plain");
            this.processor.process(exchange);
        }
    }
}

