/*
 * Decompiled with CFR 0.152.
 */
package org.drools.camel.component;

import java.util.ArrayList;
import java.util.Arrays;
import javax.naming.Context;
import org.apache.camel.builder.RouteBuilder;
import org.drools.camel.component.DroolsCamelTestSupport;
import org.drools.command.BatchExecutionCommand;
import org.drools.command.Command;
import org.drools.command.CommandFactory;
import org.drools.command.runtime.BatchExecutionCommandImpl;
import org.drools.command.runtime.rule.GetObjectCommand;
import org.drools.command.runtime.rule.InsertObjectCommand;
import org.drools.common.DefaultFactHandle;
import org.drools.pipeline.camel.Person;
import org.drools.runtime.ExecutionResults;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.runtime.rule.FactHandle;
import org.junit.Test;

public class CamelEndpointTest
extends DroolsCamelTestSupport {
    private String handle;

    @Test
    public void testSessionInsert() throws Exception {
        Person person = new Person();
        person.setName("Mauricio");
        InsertObjectCommand cmd = (InsertObjectCommand)CommandFactory.newInsert((Object)person, (String)"salaboy");
        ExecutionResults response = (ExecutionResults)this.template.requestBody("direct:test-with-session", (Object)cmd);
        CamelEndpointTest.assertTrue((String)"Expected valid ExecutionResults object", (response != null ? 1 : 0) != 0);
        CamelEndpointTest.assertTrue((String)"ExecutionResults missing expected fact", (response.getFactHandle("salaboy") != null ? 1 : 0) != 0);
        CamelEndpointTest.assertTrue((String)"ExecutionResults missing expected fact", (boolean)(response.getFactHandle("salaboy") instanceof FactHandle));
    }

    @Test
    public void testNoSessionInsert() throws Exception {
        Person person = new Person();
        person.setName("Mauricio");
        InsertObjectCommand cmd = (InsertObjectCommand)CommandFactory.newInsert((Object)person, (String)"salaboy");
        ExecutionResults response = (ExecutionResults)this.template.requestBodyAndHeader("direct:test-no-session", (Object)cmd, "DroolsLookup", (Object)"ksession1");
        CamelEndpointTest.assertTrue((String)"Expected valid ExecutionResults object", (response != null ? 1 : 0) != 0);
        CamelEndpointTest.assertTrue((String)"ExecutionResults missing expected fact", (response.getFactHandle("salaboy") != null ? 1 : 0) != 0);
    }

    @Test
    public void testSessionBatchExecutionCommand() throws Exception {
        Person john = new Person();
        john.setName("John Smith");
        ArrayList<Command> commands = new ArrayList<Command>();
        commands.add(CommandFactory.newInsert((Object)john, (String)"john"));
        BatchExecutionCommand batchExecutionCommand = CommandFactory.newBatchExecution(commands);
        ExecutionResults response = (ExecutionResults)this.template.requestBody("direct:test-with-session", (Object)batchExecutionCommand);
        CamelEndpointTest.assertTrue((String)"Expected valid ExecutionResults object", (response != null ? 1 : 0) != 0);
        CamelEndpointTest.assertTrue((String)"ExecutionResults missing expected fact", (response.getFactHandle("john") != null ? 1 : 0) != 0);
        CamelEndpointTest.assertTrue((String)"ExecutionResults missing expected fact", (boolean)(response.getFactHandle("john") instanceof FactHandle));
    }

    @Test
    public void testSessionGetObject() throws Exception {
        DefaultFactHandle factHandle = new DefaultFactHandle(this.handle);
        GetObjectCommand cmd = (GetObjectCommand)CommandFactory.newGetObject((FactHandle)factHandle);
        cmd.setOutIdentifier("rider");
        ExecutionResults response = (ExecutionResults)this.template.requestBody("direct:test-with-session", (Object)cmd);
        CamelEndpointTest.assertTrue((String)"Expected valid ExecutionResults object", (response != null ? 1 : 0) != 0);
        CamelEndpointTest.assertTrue((String)"ExecutionResults missing expected object", (response.getValue("rider") != null ? 1 : 0) != 0);
        CamelEndpointTest.assertTrue((String)"FactHandle object not of expected type", (boolean)(response.getValue("rider") instanceof Person));
        CamelEndpointTest.assertEquals((String)"Hadrian", (String)((Person)response.getValue("rider")).getName());
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:test-with-session").to("drools://node/ksession1");
                this.from("direct:test-no-session").to("drools://node");
            }
        };
    }

    protected void configureDroolsContext(Context jndiContext) {
        Person me = new Person();
        me.setName("Hadrian");
        StatefulKnowledgeSession ksession = this.registerKnowledgeRuntime("ksession1", null);
        InsertObjectCommand cmd = new InsertObjectCommand((Object)me);
        cmd.setOutIdentifier("camel-rider");
        cmd.setReturnObject(false);
        BatchExecutionCommandImpl script = new BatchExecutionCommandImpl(Arrays.asList(cmd));
        ExecutionResults results = (ExecutionResults)ksession.execute((Command)script);
        this.handle = ((FactHandle)results.getFactHandle("camel-rider")).toExternalForm();
    }
}

