/*
 * Decompiled with CFR 0.152.
 */
package org.drools.camel.component;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashSet;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.custommonkey.xmlunit.Diff;
import org.custommonkey.xmlunit.ElementQualifier;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.examples.RecursiveElementNameAndTextQualifier;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.command.Command;
import org.drools.command.CommandFactory;
import org.drools.command.runtime.BatchExecutionCommandImpl;
import org.drools.command.runtime.GetGlobalCommand;
import org.drools.command.runtime.SetGlobalCommand;
import org.drools.command.runtime.rule.InsertObjectCommand;
import org.drools.pipeline.camel.Person;
import org.drools.runtime.ExecutionResults;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.runtime.pipeline.impl.DroolsJaxbHelperProviderImpl;
import org.drools.runtime.rule.FactHandle;
import org.junit.Assert;
import org.junit.Test;

public class JaxbTest {
    @Test
    public void test1() throws Exception {
        JAXBContext jaxbContext = this.getJaxbContext();
        ArrayList<Object> cmds = new ArrayList<Object>();
        cmds.add(new InsertObjectCommand((Object)new Person("darth", 21), "p"));
        cmds.add(new GetGlobalCommand("xxx"));
        cmds.add(new SetGlobalCommand("yyy", (Object)new Person("yoda", 21)));
        BatchExecutionCommandImpl batch = new BatchExecutionCommandImpl(cmds);
        Marshaller marshaller = jaxbContext.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        marshaller.marshal((Object)batch, (OutputStream)baos);
        System.out.println(baos);
        Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
        BatchExecutionCommandImpl batch2 = (BatchExecutionCommandImpl)unmarshaller.unmarshal((InputStream)new ByteArrayInputStream(baos.toByteArray()));
        baos = new ByteArrayOutputStream();
        marshaller.marshal((Object)batch2, (OutputStream)baos);
        System.out.println(baos);
    }

    private JAXBContext getJaxbContext() throws JAXBException {
        ArrayList<String> classesName = new ArrayList<String>();
        classesName.add("org.drools.pipeline.camel.Person");
        HashSet<String> set = new HashSet<String>();
        for (String clsName : DroolsJaxbHelperProviderImpl.JAXB_ANNOTATED_CMD) {
            set.add(clsName.substring(0, clsName.lastIndexOf(46)));
        }
        for (String clsName : classesName) {
            set.add(clsName.substring(0, clsName.lastIndexOf(46)));
        }
        StringBuilder sb = new StringBuilder();
        for (String pkgName : set) {
            sb.append(pkgName);
            sb.append(':');
        }
        System.out.println("context path: " + sb.toString());
        return JAXBContext.newInstance((String)sb.toString());
    }

    @Test
    public void testFactHandleMarshall() throws JAXBException {
        JAXBContext jaxbContext = this.getJaxbContext();
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        FactHandle fh1 = ksession.insert((Object)new Person("darth", 105));
        Marshaller marshaller = jaxbContext.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        marshaller.marshal((Object)fh1, (OutputStream)baos);
        this.assertXMLEqual("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<fact-handle external-form=\"" + fh1.toExternalForm() + "\"/>", new String(baos.toByteArray()));
        Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
        FactHandle fh2 = (FactHandle)unmarshaller.unmarshal((Reader)new StringReader(baos.toString()));
        Assert.assertEquals((Object)fh1, (Object)fh2);
    }

    @Test
    public void testExecutionResults() throws JAXBException {
        JAXBContext jaxbContext = this.getJaxbContext();
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList<Command> commands = new ArrayList<Command>();
        commands.add(CommandFactory.newInsert((Object)new Person("darth", 105), (String)"p"));
        commands.add(CommandFactory.newFireAllRules());
        ExecutionResults res1 = (ExecutionResults)ksession.execute((Command)CommandFactory.newBatchExecution(commands));
        Marshaller marshaller = jaxbContext.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        marshaller.marshal((Object)res1, (OutputStream)baos);
        System.out.println(new String(baos.toByteArray()));
        Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
        ExecutionResults res2 = (ExecutionResults)unmarshaller.unmarshal((Reader)new StringReader(baos.toString()));
    }

    public void assertXMLEqual(String expectedXml, String resultXml) {
        try {
            Diff diff = new Diff(expectedXml, resultXml);
            diff.overrideElementQualifier((ElementQualifier)new RecursiveElementNameAndTextQualifier());
            XMLAssert.assertXMLEqual((Diff)diff, (boolean)true);
        }
        catch (Exception e) {
            throw new RuntimeException("XML Assertion failure", e);
        }
    }
}

