/*
 * Decompiled with CFR 0.152.
 */
package org.drools.camel.component;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.impl.DefaultConsumer;
import org.drools.camel.component.DroolsEndpoint;
import org.kie.runtime.Channel;
import org.kie.runtime.KnowledgeRuntime;

public class DroolsConsumer
extends DefaultConsumer {
    private DroolsEndpoint de;
    private KnowledgeRuntime krt;
    private String channelId;

    public DroolsConsumer(Endpoint endpoint, Processor processor) {
        super(endpoint, processor);
        this.de = (DroolsEndpoint)endpoint;
        this.krt = (KnowledgeRuntime)this.de.getExecutor();
        this.channelId = this.de.getChannel();
    }

    protected void doStop() throws Exception {
        this.krt.unregisterChannel(this.channelId);
        super.doStop();
    }

    protected void doStart() throws Exception {
        super.doStart();
        KSessionChannel channel = new KSessionChannel();
        this.krt.registerChannel(this.channelId, (Channel)channel);
    }

    class KSessionChannel
    implements Channel {
        KSessionChannel() {
        }

        public void send(Object pojo) {
            Exchange exchange = DroolsConsumer.this.de.createExchange(pojo);
            try {
                DroolsConsumer.this.getProcessor().process(exchange);
            }
            catch (Exception e) {
                DroolsConsumer.this.handleException(e);
            }
        }
    }
}

