/*
 * Decompiled with CFR 0.152.
 */
package org.drools.model.operators;

import org.assertj.core.api.Assertions;
import org.drools.model.operators.MatchesOperator;
import org.junit.After;
import org.junit.Test;

public class MatchesOperatorTest {
    @Test
    public void testMatchesOperatorCache() {
        MatchesOperator instance = MatchesOperator.INSTANCE;
        instance.forceCacheSize(100);
        Assertions.assertThat((boolean)instance.eval(null, "anything")).isFalse();
        Assertions.assertThat((int)instance.mapSize()).isEqualTo(0);
        Assertions.assertThat((boolean)instance.eval("a", "a")).isTrue();
        Assertions.assertThat((int)instance.mapSize()).isEqualTo(1);
        Assertions.assertThat((boolean)instance.eval("a", "b")).isFalse();
        Assertions.assertThat((int)instance.mapSize()).isEqualTo(2);
        Assertions.assertThat((boolean)instance.eval("a", "a")).isTrue();
        Assertions.assertThat((boolean)instance.eval("b", "b")).isTrue();
        Assertions.assertThat((boolean)instance.eval("c", "a")).isFalse();
        Assertions.assertThat((boolean)instance.eval("c", "b")).isFalse();
        Assertions.assertThat((int)instance.mapSize()).isEqualTo(2);
    }

    @Test
    public void testMatchesOperatorNoCache() {
        MatchesOperator instance = MatchesOperator.INSTANCE;
        instance.forceCacheSize(0);
        Assertions.assertThat((boolean)instance.eval(null, "anything")).isFalse();
        Assertions.assertThat((boolean)instance.eval("a", "a")).isTrue();
        Assertions.assertThat((boolean)instance.eval("a", "b")).isFalse();
        Assertions.assertThat((boolean)instance.eval("b", "a")).isFalse();
        Assertions.assertThat((boolean)instance.eval("b", "b")).isTrue();
        Assertions.assertThat((int)instance.mapSize()).isEqualTo(0);
    }

    @After
    public void resetCache() {
        MatchesOperator instance = MatchesOperator.INSTANCE;
        instance.reInitialize();
    }
}

