/*
 * Decompiled with CFR 0.152.
 */
package org.drools.model.operators;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.drools.model.functions.Operator;

public enum MatchesOperator implements Operator.SingleValue<String, String>
{
    INSTANCE;

    private static int MAX_SIZE_CACHE;
    private static final Map<String, Pattern> patternMap;

    private static int getMaxSizeCache() {
        String CACHE_MATCHES_COMPILED_MAX_PROPERTY = "drools.matches.compiled.cache.count";
        return Integer.parseInt(System.getProperty("drools.matches.compiled.cache.count", "0"));
    }

    void forceCacheSize(int size) {
        MAX_SIZE_CACHE = size;
        patternMap.clear();
    }

    void reInitialize() {
        this.forceCacheSize(MatchesOperator.getMaxSizeCache());
    }

    int mapSize() {
        return patternMap.size();
    }

    @Override
    public boolean eval(String input, String regex) {
        if (input == null) {
            return false;
        }
        if (MAX_SIZE_CACHE == 0) {
            return input.matches(regex);
        }
        Pattern pattern = patternMap.get(regex);
        if (pattern == null) {
            pattern = Pattern.compile(regex);
            patternMap.put(regex, pattern);
        }
        Matcher matcher = pattern.matcher(input);
        return matcher.matches();
    }

    @Override
    public String getOperatorName() {
        return "matches";
    }

    static {
        MAX_SIZE_CACHE = MatchesOperator.getMaxSizeCache();
        patternMap = Collections.synchronizedMap(new LinkedHashMap<String, Pattern>(){

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, Pattern> eldest) {
                return this.size() > MAX_SIZE_CACHE;
            }
        });
    }
}

